package zio.aws.elasticache.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class CacheNodeTypeSpecificValue(
    cacheNodeType: Option[String] = None,
    value: Option[String] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.elasticache.model.CacheNodeTypeSpecificValue = {
    import CacheNodeTypeSpecificValue.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.elasticache.model.CacheNodeTypeSpecificValue
      .builder()
      .optionallyWith(cacheNodeType.map(value => value: java.lang.String))(
        _.cacheNodeType
      )
      .optionallyWith(value.map(value => value: java.lang.String))(_.value)
      .build()
  }
  def asReadOnly
      : zio.aws.elasticache.model.CacheNodeTypeSpecificValue.ReadOnly =
    zio.aws.elasticache.model.CacheNodeTypeSpecificValue.wrap(buildAwsValue())
}
object CacheNodeTypeSpecificValue {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.elasticache.model.CacheNodeTypeSpecificValue
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.elasticache.model.CacheNodeTypeSpecificValue =
      zio.aws.elasticache.model.CacheNodeTypeSpecificValue(
        cacheNodeType.map(value => value),
        value.map(value => value)
      )
    def cacheNodeType: Option[String]
    def value: Option[String]
    def getCacheNodeType: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("cacheNodeType", cacheNodeType)
    def getValue: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("value", value)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.elasticache.model.CacheNodeTypeSpecificValue
  ) extends zio.aws.elasticache.model.CacheNodeTypeSpecificValue.ReadOnly {
    override val cacheNodeType: Option[String] =
      scala.Option(impl.cacheNodeType()).map(value => value: String)
    override val value: Option[String] =
      scala.Option(impl.value()).map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.elasticache.model.CacheNodeTypeSpecificValue
  ): zio.aws.elasticache.model.CacheNodeTypeSpecificValue.ReadOnly =
    new Wrapper(impl)
}
