package zio.aws.elasticache.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class CacheEngineVersion(
    engine: Option[String] = None,
    engineVersion: Option[String] = None,
    cacheParameterGroupFamily: Option[String] = None,
    cacheEngineDescription: Option[String] = None,
    cacheEngineVersionDescription: Option[String] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.elasticache.model.CacheEngineVersion = {
    import CacheEngineVersion.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.elasticache.model.CacheEngineVersion
      .builder()
      .optionallyWith(engine.map(value => value: java.lang.String))(_.engine)
      .optionallyWith(engineVersion.map(value => value: java.lang.String))(
        _.engineVersion
      )
      .optionallyWith(
        cacheParameterGroupFamily.map(value => value: java.lang.String)
      )(_.cacheParameterGroupFamily)
      .optionallyWith(
        cacheEngineDescription.map(value => value: java.lang.String)
      )(_.cacheEngineDescription)
      .optionallyWith(
        cacheEngineVersionDescription.map(value => value: java.lang.String)
      )(_.cacheEngineVersionDescription)
      .build()
  }
  def asReadOnly: zio.aws.elasticache.model.CacheEngineVersion.ReadOnly =
    zio.aws.elasticache.model.CacheEngineVersion.wrap(buildAwsValue())
}
object CacheEngineVersion {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.elasticache.model.CacheEngineVersion
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.elasticache.model.CacheEngineVersion =
      zio.aws.elasticache.model.CacheEngineVersion(
        engine.map(value => value),
        engineVersion.map(value => value),
        cacheParameterGroupFamily.map(value => value),
        cacheEngineDescription.map(value => value),
        cacheEngineVersionDescription.map(value => value)
      )
    def engine: Option[String]
    def engineVersion: Option[String]
    def cacheParameterGroupFamily: Option[String]
    def cacheEngineDescription: Option[String]
    def cacheEngineVersionDescription: Option[String]
    def getEngine: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("engine", engine)
    def getEngineVersion: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("engineVersion", engineVersion)
    def getCacheParameterGroupFamily: ZIO[Any, AwsError, String] = AwsError
      .unwrapOptionField("cacheParameterGroupFamily", cacheParameterGroupFamily)
    def getCacheEngineDescription: ZIO[Any, AwsError, String] = AwsError
      .unwrapOptionField("cacheEngineDescription", cacheEngineDescription)
    def getCacheEngineVersionDescription: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField(
        "cacheEngineVersionDescription",
        cacheEngineVersionDescription
      )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.elasticache.model.CacheEngineVersion
  ) extends zio.aws.elasticache.model.CacheEngineVersion.ReadOnly {
    override val engine: Option[String] =
      scala.Option(impl.engine()).map(value => value: String)
    override val engineVersion: Option[String] =
      scala.Option(impl.engineVersion()).map(value => value: String)
    override val cacheParameterGroupFamily: Option[String] =
      scala.Option(impl.cacheParameterGroupFamily()).map(value => value: String)
    override val cacheEngineDescription: Option[String] =
      scala.Option(impl.cacheEngineDescription()).map(value => value: String)
    override val cacheEngineVersionDescription: Option[String] = scala
      .Option(impl.cacheEngineVersionDescription())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.elasticache.model.CacheEngineVersion
  ): zio.aws.elasticache.model.CacheEngineVersion.ReadOnly = new Wrapper(impl)
}
