package zio.aws.elasticache.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class BatchStopUpdateActionResponse(
    processedUpdateActions: Option[
      Iterable[zio.aws.elasticache.model.ProcessedUpdateAction]
    ] = None,
    unprocessedUpdateActions: Option[
      Iterable[zio.aws.elasticache.model.UnprocessedUpdateAction]
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.elasticache.model.BatchStopUpdateActionResponse = {
    import BatchStopUpdateActionResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.elasticache.model.BatchStopUpdateActionResponse
      .builder()
      .optionallyWith(
        processedUpdateActions.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.processedUpdateActions)
      .optionallyWith(
        unprocessedUpdateActions.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.unprocessedUpdateActions)
      .build()
  }
  def asReadOnly
      : zio.aws.elasticache.model.BatchStopUpdateActionResponse.ReadOnly =
    zio.aws.elasticache.model.BatchStopUpdateActionResponse
      .wrap(buildAwsValue())
}
object BatchStopUpdateActionResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.elasticache.model.BatchStopUpdateActionResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.elasticache.model.BatchStopUpdateActionResponse =
      zio.aws.elasticache.model.BatchStopUpdateActionResponse(
        processedUpdateActions.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        unprocessedUpdateActions.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def processedUpdateActions
        : Option[List[zio.aws.elasticache.model.ProcessedUpdateAction.ReadOnly]]
    def unprocessedUpdateActions: Option[
      List[zio.aws.elasticache.model.UnprocessedUpdateAction.ReadOnly]
    ]
    def getProcessedUpdateActions: ZIO[Any, AwsError, List[
      zio.aws.elasticache.model.ProcessedUpdateAction.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "processedUpdateActions",
      processedUpdateActions
    )
    def getUnprocessedUpdateActions: ZIO[Any, AwsError, List[
      zio.aws.elasticache.model.UnprocessedUpdateAction.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "unprocessedUpdateActions",
      unprocessedUpdateActions
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.elasticache.model.BatchStopUpdateActionResponse
  ) extends zio.aws.elasticache.model.BatchStopUpdateActionResponse.ReadOnly {
    override val processedUpdateActions: Option[
      List[zio.aws.elasticache.model.ProcessedUpdateAction.ReadOnly]
    ] = scala
      .Option(impl.processedUpdateActions())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.elasticache.model.ProcessedUpdateAction.wrap(item)
        }.toList
      )
    override val unprocessedUpdateActions: Option[
      List[zio.aws.elasticache.model.UnprocessedUpdateAction.ReadOnly]
    ] = scala
      .Option(impl.unprocessedUpdateActions())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.elasticache.model.UnprocessedUpdateAction.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.elasticache.model.BatchStopUpdateActionResponse
  ): zio.aws.elasticache.model.BatchStopUpdateActionResponse.ReadOnly =
    new Wrapper(impl)
}
