package zio.aws.elasticache.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class BatchApplyUpdateActionResponse(
    processedUpdateActions: Optional[
      Iterable[zio.aws.elasticache.model.ProcessedUpdateAction]
    ] = Optional.Absent,
    unprocessedUpdateActions: Optional[
      Iterable[zio.aws.elasticache.model.UnprocessedUpdateAction]
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.elasticache.model.BatchApplyUpdateActionResponse = {
    import BatchApplyUpdateActionResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.elasticache.model.BatchApplyUpdateActionResponse
      .builder()
      .optionallyWith(
        processedUpdateActions.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.processedUpdateActions)
      .optionallyWith(
        unprocessedUpdateActions.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.unprocessedUpdateActions)
      .build()
  }
  def asReadOnly
      : zio.aws.elasticache.model.BatchApplyUpdateActionResponse.ReadOnly =
    zio.aws.elasticache.model.BatchApplyUpdateActionResponse
      .wrap(buildAwsValue())
}
object BatchApplyUpdateActionResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.elasticache.model.BatchApplyUpdateActionResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.elasticache.model.BatchApplyUpdateActionResponse =
      zio.aws.elasticache.model.BatchApplyUpdateActionResponse(
        processedUpdateActions.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        unprocessedUpdateActions.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def processedUpdateActions: Optional[
      List[zio.aws.elasticache.model.ProcessedUpdateAction.ReadOnly]
    ]
    def unprocessedUpdateActions: Optional[
      List[zio.aws.elasticache.model.UnprocessedUpdateAction.ReadOnly]
    ]
    def getProcessedUpdateActions: ZIO[Any, AwsError, List[
      zio.aws.elasticache.model.ProcessedUpdateAction.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "processedUpdateActions",
      processedUpdateActions
    )
    def getUnprocessedUpdateActions: ZIO[Any, AwsError, List[
      zio.aws.elasticache.model.UnprocessedUpdateAction.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "unprocessedUpdateActions",
      unprocessedUpdateActions
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.elasticache.model.BatchApplyUpdateActionResponse
  ) extends zio.aws.elasticache.model.BatchApplyUpdateActionResponse.ReadOnly {
    override val processedUpdateActions: Optional[
      List[zio.aws.elasticache.model.ProcessedUpdateAction.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.processedUpdateActions())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.elasticache.model.ProcessedUpdateAction.wrap(item)
        }.toList
      )
    override val unprocessedUpdateActions: Optional[
      List[zio.aws.elasticache.model.UnprocessedUpdateAction.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.unprocessedUpdateActions())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.elasticache.model.UnprocessedUpdateAction.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.elasticache.model.BatchApplyUpdateActionResponse
  ): zio.aws.elasticache.model.BatchApplyUpdateActionResponse.ReadOnly =
    new Wrapper(impl)
}
