package zio.aws.elasticache.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class GlobalReplicationGroupInfo(
    globalReplicationGroupId: Optional[String] = Optional.Absent,
    globalReplicationGroupMemberRole: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.elasticache.model.GlobalReplicationGroupInfo = {
    import GlobalReplicationGroupInfo.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.elasticache.model.GlobalReplicationGroupInfo
      .builder()
      .optionallyWith(
        globalReplicationGroupId.map(value => value: java.lang.String)
      )(_.globalReplicationGroupId)
      .optionallyWith(
        globalReplicationGroupMemberRole.map(value => value: java.lang.String)
      )(_.globalReplicationGroupMemberRole)
      .build()
  }
  def asReadOnly
      : zio.aws.elasticache.model.GlobalReplicationGroupInfo.ReadOnly =
    zio.aws.elasticache.model.GlobalReplicationGroupInfo.wrap(buildAwsValue())
}
object GlobalReplicationGroupInfo {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.elasticache.model.GlobalReplicationGroupInfo
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.elasticache.model.GlobalReplicationGroupInfo =
      zio.aws.elasticache.model.GlobalReplicationGroupInfo(
        globalReplicationGroupId.map(value => value),
        globalReplicationGroupMemberRole.map(value => value)
      )
    def globalReplicationGroupId: Optional[String]
    def globalReplicationGroupMemberRole: Optional[String]
    def getGlobalReplicationGroupId: ZIO[Any, AwsError, String] = AwsError
      .unwrapOptionField("globalReplicationGroupId", globalReplicationGroupId)
    def getGlobalReplicationGroupMemberRole: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField(
        "globalReplicationGroupMemberRole",
        globalReplicationGroupMemberRole
      )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.elasticache.model.GlobalReplicationGroupInfo
  ) extends zio.aws.elasticache.model.GlobalReplicationGroupInfo.ReadOnly {
    override val globalReplicationGroupId: Optional[String] =
      zio.aws.core.internal
        .optionalFromNullable(impl.globalReplicationGroupId())
        .map(value => value: String)
    override val globalReplicationGroupMemberRole: Optional[String] =
      zio.aws.core.internal
        .optionalFromNullable(impl.globalReplicationGroupMemberRole())
        .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.elasticache.model.GlobalReplicationGroupInfo
  ): zio.aws.elasticache.model.GlobalReplicationGroupInfo.ReadOnly =
    new Wrapper(impl)
}
