package zio.aws.elasticache.model
import scala.jdk.CollectionConverters._
sealed trait NetworkType {
  def unwrap: software.amazon.awssdk.services.elasticache.model.NetworkType
}
object NetworkType {
  def wrap(
      value: software.amazon.awssdk.services.elasticache.model.NetworkType
  ): zio.aws.elasticache.model.NetworkType = value match {
    case software.amazon.awssdk.services.elasticache.model.NetworkType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.elasticache.model.NetworkType.IPV4 =>
      val r = ipv4
      r
    case software.amazon.awssdk.services.elasticache.model.NetworkType.IPV6 =>
      val r = ipv6
      r
    case software.amazon.awssdk.services.elasticache.model.NetworkType.DUAL_STACK =>
      val r = dual_stack
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.elasticache.model.NetworkType {
    override def unwrap
        : software.amazon.awssdk.services.elasticache.model.NetworkType =
      software.amazon.awssdk.services.elasticache.model.NetworkType.UNKNOWN_TO_SDK_VERSION
  }
  case object ipv4 extends zio.aws.elasticache.model.NetworkType {
    override def unwrap
        : software.amazon.awssdk.services.elasticache.model.NetworkType =
      software.amazon.awssdk.services.elasticache.model.NetworkType.IPV4
  }
  case object ipv6 extends zio.aws.elasticache.model.NetworkType {
    override def unwrap
        : software.amazon.awssdk.services.elasticache.model.NetworkType =
      software.amazon.awssdk.services.elasticache.model.NetworkType.IPV6
  }
  case object dual_stack extends zio.aws.elasticache.model.NetworkType {
    override def unwrap
        : software.amazon.awssdk.services.elasticache.model.NetworkType =
      software.amazon.awssdk.services.elasticache.model.NetworkType.DUAL_STACK
  }
}
