package zio.aws.elasticache.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class RemoveTagsFromResourceRequest(
    resourceName: String,
    tagKeys: Iterable[String]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.elasticache.model.RemoveTagsFromResourceRequest = {
    import RemoveTagsFromResourceRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.elasticache.model.RemoveTagsFromResourceRequest
      .builder()
      .resourceName(resourceName: java.lang.String)
      .tagKeys(tagKeys.map { item =>
        item: java.lang.String
      }.asJavaCollection)
      .build()
  }
  def asReadOnly
      : zio.aws.elasticache.model.RemoveTagsFromResourceRequest.ReadOnly =
    zio.aws.elasticache.model.RemoveTagsFromResourceRequest
      .wrap(buildAwsValue())
}
object RemoveTagsFromResourceRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.elasticache.model.RemoveTagsFromResourceRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.elasticache.model.RemoveTagsFromResourceRequest =
      zio.aws.elasticache.model
        .RemoveTagsFromResourceRequest(resourceName, tagKeys)
    def resourceName: String
    def tagKeys: List[String]
    def getResourceName: ZIO[Any, Nothing, String] = ZIO.succeed(resourceName)
    def getTagKeys: ZIO[Any, Nothing, List[String]] = ZIO.succeed(tagKeys)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.elasticache.model.RemoveTagsFromResourceRequest
  ) extends zio.aws.elasticache.model.RemoveTagsFromResourceRequest.ReadOnly {
    override val resourceName: String = impl.resourceName(): String
    override val tagKeys: List[String] = impl
      .tagKeys()
      .asScala
      .map { item =>
        item: String
      }
      .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.elasticache.model.RemoveTagsFromResourceRequest
  ): zio.aws.elasticache.model.RemoveTagsFromResourceRequest.ReadOnly =
    new Wrapper(impl)
}
