package zio.aws.elasticache.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class AuthenticationMode(
    `type`: Optional[zio.aws.elasticache.model.InputAuthenticationType] =
      Optional.Absent,
    passwords: Optional[Iterable[String]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.elasticache.model.AuthenticationMode = {
    import AuthenticationMode.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.elasticache.model.AuthenticationMode
      .builder()
      .optionallyWith(`type`.map(value => value.unwrap))(_.`type`)
      .optionallyWith(
        passwords.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.passwords)
      .build()
  }
  def asReadOnly: zio.aws.elasticache.model.AuthenticationMode.ReadOnly =
    zio.aws.elasticache.model.AuthenticationMode.wrap(buildAwsValue())
}
object AuthenticationMode {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.elasticache.model.AuthenticationMode
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.elasticache.model.AuthenticationMode =
      zio.aws.elasticache.model.AuthenticationMode(
        `type`.map(value => value),
        passwords.map(value => value)
      )
    def `type`: Optional[zio.aws.elasticache.model.InputAuthenticationType]
    def passwords: Optional[List[String]]
    def getType: ZIO[
      Any,
      AwsError,
      zio.aws.elasticache.model.InputAuthenticationType
    ] = AwsError.unwrapOptionField("type", `type`)
    def getPasswords: ZIO[Any, AwsError, List[String]] =
      AwsError.unwrapOptionField("passwords", passwords)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.elasticache.model.AuthenticationMode
  ) extends zio.aws.elasticache.model.AuthenticationMode.ReadOnly {
    override val `type`
        : Optional[zio.aws.elasticache.model.InputAuthenticationType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.`type`())
        .map(value =>
          zio.aws.elasticache.model.InputAuthenticationType.wrap(value)
        )
    override val passwords: Optional[List[String]] = zio.aws.core.internal
      .optionalFromNullable(impl.passwords())
      .map(value =>
        value.asScala.map { item =>
          item: String
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.elasticache.model.AuthenticationMode
  ): zio.aws.elasticache.model.AuthenticationMode.ReadOnly = new Wrapper(impl)
}
