package zio.aws.elasticache.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class TestMigrationRequest(
    replicationGroupId: String,
    customerNodeEndpointList: Iterable[
      zio.aws.elasticache.model.CustomerNodeEndpoint
    ]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.elasticache.model.TestMigrationRequest = {
    import TestMigrationRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.elasticache.model.TestMigrationRequest
      .builder()
      .replicationGroupId(replicationGroupId: java.lang.String)
      .customerNodeEndpointList(customerNodeEndpointList.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .build()
  }
  def asReadOnly: zio.aws.elasticache.model.TestMigrationRequest.ReadOnly =
    zio.aws.elasticache.model.TestMigrationRequest.wrap(buildAwsValue())
}
object TestMigrationRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.elasticache.model.TestMigrationRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.elasticache.model.TestMigrationRequest =
      zio.aws.elasticache.model.TestMigrationRequest(
        replicationGroupId,
        customerNodeEndpointList.map { item =>
          item.asEditable
        }
      )
    def replicationGroupId: String
    def customerNodeEndpointList
        : List[zio.aws.elasticache.model.CustomerNodeEndpoint.ReadOnly]
    def getReplicationGroupId: ZIO[Any, Nothing, String] =
      ZIO.succeed(replicationGroupId)
    def getCustomerNodeEndpointList: ZIO[Any, Nothing, List[
      zio.aws.elasticache.model.CustomerNodeEndpoint.ReadOnly
    ]] = ZIO.succeed(customerNodeEndpointList)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.elasticache.model.TestMigrationRequest
  ) extends zio.aws.elasticache.model.TestMigrationRequest.ReadOnly {
    override val replicationGroupId: String = impl.replicationGroupId(): String
    override val customerNodeEndpointList
        : List[zio.aws.elasticache.model.CustomerNodeEndpoint.ReadOnly] = impl
      .customerNodeEndpointList()
      .asScala
      .map { item =>
        zio.aws.elasticache.model.CustomerNodeEndpoint.wrap(item)
      }
      .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.elasticache.model.TestMigrationRequest
  ): zio.aws.elasticache.model.TestMigrationRequest.ReadOnly = new Wrapper(impl)
}
