package zio.aws.elasticache.model
import scala.jdk.CollectionConverters._
sealed trait InputAuthenticationType {
  def unwrap: software.amazon.awssdk.services.elasticache.model.InputAuthenticationType
}
object InputAuthenticationType {
  def wrap(
      value: software.amazon.awssdk.services.elasticache.model.InputAuthenticationType
  ): zio.aws.elasticache.model.InputAuthenticationType = value match {
    case software.amazon.awssdk.services.elasticache.model.InputAuthenticationType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.elasticache.model.InputAuthenticationType.PASSWORD =>
      val r = password
      r
    case software.amazon.awssdk.services.elasticache.model.InputAuthenticationType.NO_PASSWORD_REQUIRED =>
      val r = `no-password-required`
      r
    case software.amazon.awssdk.services.elasticache.model.InputAuthenticationType.IAM =>
      val r = iam
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.elasticache.model.InputAuthenticationType {
    override def unwrap
        : software.amazon.awssdk.services.elasticache.model.InputAuthenticationType =
      software.amazon.awssdk.services.elasticache.model.InputAuthenticationType.UNKNOWN_TO_SDK_VERSION
  }
  case object password
      extends zio.aws.elasticache.model.InputAuthenticationType {
    override def unwrap
        : software.amazon.awssdk.services.elasticache.model.InputAuthenticationType =
      software.amazon.awssdk.services.elasticache.model.InputAuthenticationType.PASSWORD
  }
  case object `no-password-required`
      extends zio.aws.elasticache.model.InputAuthenticationType {
    override def unwrap
        : software.amazon.awssdk.services.elasticache.model.InputAuthenticationType =
      software.amazon.awssdk.services.elasticache.model.InputAuthenticationType.NO_PASSWORD_REQUIRED
  }
  case object iam extends zio.aws.elasticache.model.InputAuthenticationType {
    override def unwrap
        : software.amazon.awssdk.services.elasticache.model.InputAuthenticationType =
      software.amazon.awssdk.services.elasticache.model.InputAuthenticationType.IAM
  }
}
