package zio.aws.elasticache.model
import zio.aws.elasticache.model.primitives.{UserId, EngineType}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ModifyUserGroupResponse(
    userGroupId: Optional[String] = Optional.Absent,
    status: Optional[String] = Optional.Absent,
    engine: Optional[EngineType] = Optional.Absent,
    userIds: Optional[Iterable[UserId]] = Optional.Absent,
    minimumEngineVersion: Optional[String] = Optional.Absent,
    pendingChanges: Optional[
      zio.aws.elasticache.model.UserGroupPendingChanges
    ] = Optional.Absent,
    replicationGroups: Optional[Iterable[String]] = Optional.Absent,
    arn: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.elasticache.model.ModifyUserGroupResponse = {
    import ModifyUserGroupResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.elasticache.model.ModifyUserGroupResponse
      .builder()
      .optionallyWith(userGroupId.map(value => value: java.lang.String))(
        _.userGroupId
      )
      .optionallyWith(status.map(value => value: java.lang.String))(_.status)
      .optionallyWith(
        engine.map(value => EngineType.unwrap(value): java.lang.String)
      )(_.engine)
      .optionallyWith(
        userIds.map(value =>
          value.map { item =>
            UserId.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.userIds)
      .optionallyWith(
        minimumEngineVersion.map(value => value: java.lang.String)
      )(_.minimumEngineVersion)
      .optionallyWith(pendingChanges.map(value => value.buildAwsValue()))(
        _.pendingChanges
      )
      .optionallyWith(
        replicationGroups.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.replicationGroups)
      .optionallyWith(arn.map(value => value: java.lang.String))(_.arn)
      .build()
  }
  def asReadOnly: zio.aws.elasticache.model.ModifyUserGroupResponse.ReadOnly =
    zio.aws.elasticache.model.ModifyUserGroupResponse.wrap(buildAwsValue())
}
object ModifyUserGroupResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.elasticache.model.ModifyUserGroupResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.elasticache.model.ModifyUserGroupResponse =
      zio.aws.elasticache.model.ModifyUserGroupResponse(
        userGroupId.map(value => value),
        status.map(value => value),
        engine.map(value => value),
        userIds.map(value => value),
        minimumEngineVersion.map(value => value),
        pendingChanges.map(value => value.asEditable),
        replicationGroups.map(value => value),
        arn.map(value => value)
      )
    def userGroupId: Optional[String]
    def status: Optional[String]
    def engine: Optional[EngineType]
    def userIds: Optional[List[UserId]]
    def minimumEngineVersion: Optional[String]
    def pendingChanges
        : Optional[zio.aws.elasticache.model.UserGroupPendingChanges.ReadOnly]
    def replicationGroups: Optional[List[String]]
    def arn: Optional[String]
    def getUserGroupId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("userGroupId", userGroupId)
    def getStatus: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("status", status)
    def getEngine: ZIO[Any, AwsError, EngineType] =
      AwsError.unwrapOptionField("engine", engine)
    def getUserIds: ZIO[Any, AwsError, List[UserId]] =
      AwsError.unwrapOptionField("userIds", userIds)
    def getMinimumEngineVersion: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("minimumEngineVersion", minimumEngineVersion)
    def getPendingChanges: ZIO[
      Any,
      AwsError,
      zio.aws.elasticache.model.UserGroupPendingChanges.ReadOnly
    ] = AwsError.unwrapOptionField("pendingChanges", pendingChanges)
    def getReplicationGroups: ZIO[Any, AwsError, List[String]] =
      AwsError.unwrapOptionField("replicationGroups", replicationGroups)
    def getArn: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("arn", arn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.elasticache.model.ModifyUserGroupResponse
  ) extends zio.aws.elasticache.model.ModifyUserGroupResponse.ReadOnly {
    override val userGroupId: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.userGroupId())
      .map(value => value: String)
    override val status: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.status())
      .map(value => value: String)
    override val engine: Optional[EngineType] = zio.aws.core.internal
      .optionalFromNullable(impl.engine())
      .map(value => zio.aws.elasticache.model.primitives.EngineType(value))
    override val userIds: Optional[List[UserId]] = zio.aws.core.internal
      .optionalFromNullable(impl.userIds())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.elasticache.model.primitives.UserId(item)
        }.toList
      )
    override val minimumEngineVersion: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.minimumEngineVersion())
      .map(value => value: String)
    override val pendingChanges
        : Optional[zio.aws.elasticache.model.UserGroupPendingChanges.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.pendingChanges())
        .map(value =>
          zio.aws.elasticache.model.UserGroupPendingChanges.wrap(value)
        )
    override val replicationGroups: Optional[List[String]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.replicationGroups())
        .map(value =>
          value.asScala.map { item =>
            item: String
          }.toList
        )
    override val arn: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.arn())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.elasticache.model.ModifyUserGroupResponse
  ): zio.aws.elasticache.model.ModifyUserGroupResponse.ReadOnly = new Wrapper(
    impl
  )
}
