package zio.aws.elasticache.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.elasticache.model.primitives.{
  UserGroupId,
  IntegerOptional,
  BooleanOptional
}
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class CreateReplicationGroupRequest(
    replicationGroupId: String,
    replicationGroupDescription: String,
    globalReplicationGroupId: Optional[String] = Optional.Absent,
    primaryClusterId: Optional[String] = Optional.Absent,
    automaticFailoverEnabled: Optional[BooleanOptional] = Optional.Absent,
    multiAZEnabled: Optional[BooleanOptional] = Optional.Absent,
    numCacheClusters: Optional[IntegerOptional] = Optional.Absent,
    preferredCacheClusterAZs: Optional[Iterable[String]] = Optional.Absent,
    numNodeGroups: Optional[IntegerOptional] = Optional.Absent,
    replicasPerNodeGroup: Optional[IntegerOptional] = Optional.Absent,
    nodeGroupConfiguration: Optional[
      Iterable[zio.aws.elasticache.model.NodeGroupConfiguration]
    ] = Optional.Absent,
    cacheNodeType: Optional[String] = Optional.Absent,
    engine: Optional[String] = Optional.Absent,
    engineVersion: Optional[String] = Optional.Absent,
    cacheParameterGroupName: Optional[String] = Optional.Absent,
    cacheSubnetGroupName: Optional[String] = Optional.Absent,
    cacheSecurityGroupNames: Optional[Iterable[String]] = Optional.Absent,
    securityGroupIds: Optional[Iterable[String]] = Optional.Absent,
    tags: Optional[Iterable[zio.aws.elasticache.model.Tag]] = Optional.Absent,
    snapshotArns: Optional[Iterable[String]] = Optional.Absent,
    snapshotName: Optional[String] = Optional.Absent,
    preferredMaintenanceWindow: Optional[String] = Optional.Absent,
    port: Optional[IntegerOptional] = Optional.Absent,
    notificationTopicArn: Optional[String] = Optional.Absent,
    autoMinorVersionUpgrade: Optional[BooleanOptional] = Optional.Absent,
    snapshotRetentionLimit: Optional[IntegerOptional] = Optional.Absent,
    snapshotWindow: Optional[String] = Optional.Absent,
    authToken: Optional[String] = Optional.Absent,
    transitEncryptionEnabled: Optional[BooleanOptional] = Optional.Absent,
    atRestEncryptionEnabled: Optional[BooleanOptional] = Optional.Absent,
    kmsKeyId: Optional[String] = Optional.Absent,
    userGroupIds: Optional[Iterable[UserGroupId]] = Optional.Absent,
    logDeliveryConfigurations: Optional[
      Iterable[zio.aws.elasticache.model.LogDeliveryConfigurationRequest]
    ] = Optional.Absent,
    dataTieringEnabled: Optional[BooleanOptional] = Optional.Absent,
    networkType: Optional[zio.aws.elasticache.model.NetworkType] =
      Optional.Absent,
    ipDiscovery: Optional[zio.aws.elasticache.model.IpDiscovery] =
      Optional.Absent,
    transitEncryptionMode: Optional[
      zio.aws.elasticache.model.TransitEncryptionMode
    ] = Optional.Absent,
    clusterMode: Optional[zio.aws.elasticache.model.ClusterMode] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.elasticache.model.CreateReplicationGroupRequest = {
    import CreateReplicationGroupRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.elasticache.model.CreateReplicationGroupRequest
      .builder()
      .replicationGroupId(replicationGroupId: java.lang.String)
      .replicationGroupDescription(
        replicationGroupDescription: java.lang.String
      )
      .optionallyWith(
        globalReplicationGroupId.map(value => value: java.lang.String)
      )(_.globalReplicationGroupId)
      .optionallyWith(primaryClusterId.map(value => value: java.lang.String))(
        _.primaryClusterId
      )
      .optionallyWith(
        automaticFailoverEnabled.map(value => value: java.lang.Boolean)
      )(_.automaticFailoverEnabled)
      .optionallyWith(multiAZEnabled.map(value => value: java.lang.Boolean))(
        _.multiAZEnabled
      )
      .optionallyWith(numCacheClusters.map(value => value: Integer))(
        _.numCacheClusters
      )
      .optionallyWith(
        preferredCacheClusterAZs.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.preferredCacheClusterAZs)
      .optionallyWith(numNodeGroups.map(value => value: Integer))(
        _.numNodeGroups
      )
      .optionallyWith(replicasPerNodeGroup.map(value => value: Integer))(
        _.replicasPerNodeGroup
      )
      .optionallyWith(
        nodeGroupConfiguration.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.nodeGroupConfiguration)
      .optionallyWith(cacheNodeType.map(value => value: java.lang.String))(
        _.cacheNodeType
      )
      .optionallyWith(engine.map(value => value: java.lang.String))(_.engine)
      .optionallyWith(engineVersion.map(value => value: java.lang.String))(
        _.engineVersion
      )
      .optionallyWith(
        cacheParameterGroupName.map(value => value: java.lang.String)
      )(_.cacheParameterGroupName)
      .optionallyWith(
        cacheSubnetGroupName.map(value => value: java.lang.String)
      )(_.cacheSubnetGroupName)
      .optionallyWith(
        cacheSecurityGroupNames.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.cacheSecurityGroupNames)
      .optionallyWith(
        securityGroupIds.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.securityGroupIds)
      .optionallyWith(
        tags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tags)
      .optionallyWith(
        snapshotArns.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.snapshotArns)
      .optionallyWith(snapshotName.map(value => value: java.lang.String))(
        _.snapshotName
      )
      .optionallyWith(
        preferredMaintenanceWindow.map(value => value: java.lang.String)
      )(_.preferredMaintenanceWindow)
      .optionallyWith(port.map(value => value: Integer))(_.port)
      .optionallyWith(
        notificationTopicArn.map(value => value: java.lang.String)
      )(_.notificationTopicArn)
      .optionallyWith(
        autoMinorVersionUpgrade.map(value => value: java.lang.Boolean)
      )(_.autoMinorVersionUpgrade)
      .optionallyWith(snapshotRetentionLimit.map(value => value: Integer))(
        _.snapshotRetentionLimit
      )
      .optionallyWith(snapshotWindow.map(value => value: java.lang.String))(
        _.snapshotWindow
      )
      .optionallyWith(authToken.map(value => value: java.lang.String))(
        _.authToken
      )
      .optionallyWith(
        transitEncryptionEnabled.map(value => value: java.lang.Boolean)
      )(_.transitEncryptionEnabled)
      .optionallyWith(
        atRestEncryptionEnabled.map(value => value: java.lang.Boolean)
      )(_.atRestEncryptionEnabled)
      .optionallyWith(kmsKeyId.map(value => value: java.lang.String))(
        _.kmsKeyId
      )
      .optionallyWith(
        userGroupIds.map(value =>
          value.map { item =>
            UserGroupId.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.userGroupIds)
      .optionallyWith(
        logDeliveryConfigurations.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.logDeliveryConfigurations)
      .optionallyWith(
        dataTieringEnabled.map(value => value: java.lang.Boolean)
      )(_.dataTieringEnabled)
      .optionallyWith(networkType.map(value => value.unwrap))(_.networkType)
      .optionallyWith(ipDiscovery.map(value => value.unwrap))(_.ipDiscovery)
      .optionallyWith(transitEncryptionMode.map(value => value.unwrap))(
        _.transitEncryptionMode
      )
      .optionallyWith(clusterMode.map(value => value.unwrap))(_.clusterMode)
      .build()
  }
  def asReadOnly
      : zio.aws.elasticache.model.CreateReplicationGroupRequest.ReadOnly =
    zio.aws.elasticache.model.CreateReplicationGroupRequest
      .wrap(buildAwsValue())
}
object CreateReplicationGroupRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.elasticache.model.CreateReplicationGroupRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.elasticache.model.CreateReplicationGroupRequest =
      zio.aws.elasticache.model.CreateReplicationGroupRequest(
        replicationGroupId,
        replicationGroupDescription,
        globalReplicationGroupId.map(value => value),
        primaryClusterId.map(value => value),
        automaticFailoverEnabled.map(value => value),
        multiAZEnabled.map(value => value),
        numCacheClusters.map(value => value),
        preferredCacheClusterAZs.map(value => value),
        numNodeGroups.map(value => value),
        replicasPerNodeGroup.map(value => value),
        nodeGroupConfiguration.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        cacheNodeType.map(value => value),
        engine.map(value => value),
        engineVersion.map(value => value),
        cacheParameterGroupName.map(value => value),
        cacheSubnetGroupName.map(value => value),
        cacheSecurityGroupNames.map(value => value),
        securityGroupIds.map(value => value),
        tags.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        snapshotArns.map(value => value),
        snapshotName.map(value => value),
        preferredMaintenanceWindow.map(value => value),
        port.map(value => value),
        notificationTopicArn.map(value => value),
        autoMinorVersionUpgrade.map(value => value),
        snapshotRetentionLimit.map(value => value),
        snapshotWindow.map(value => value),
        authToken.map(value => value),
        transitEncryptionEnabled.map(value => value),
        atRestEncryptionEnabled.map(value => value),
        kmsKeyId.map(value => value),
        userGroupIds.map(value => value),
        logDeliveryConfigurations.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        dataTieringEnabled.map(value => value),
        networkType.map(value => value),
        ipDiscovery.map(value => value),
        transitEncryptionMode.map(value => value),
        clusterMode.map(value => value)
      )
    def replicationGroupId: String
    def replicationGroupDescription: String
    def globalReplicationGroupId: Optional[String]
    def primaryClusterId: Optional[String]
    def automaticFailoverEnabled: Optional[BooleanOptional]
    def multiAZEnabled: Optional[BooleanOptional]
    def numCacheClusters: Optional[IntegerOptional]
    def preferredCacheClusterAZs: Optional[List[String]]
    def numNodeGroups: Optional[IntegerOptional]
    def replicasPerNodeGroup: Optional[IntegerOptional]
    def nodeGroupConfiguration: Optional[
      List[zio.aws.elasticache.model.NodeGroupConfiguration.ReadOnly]
    ]
    def cacheNodeType: Optional[String]
    def engine: Optional[String]
    def engineVersion: Optional[String]
    def cacheParameterGroupName: Optional[String]
    def cacheSubnetGroupName: Optional[String]
    def cacheSecurityGroupNames: Optional[List[String]]
    def securityGroupIds: Optional[List[String]]
    def tags: Optional[List[zio.aws.elasticache.model.Tag.ReadOnly]]
    def snapshotArns: Optional[List[String]]
    def snapshotName: Optional[String]
    def preferredMaintenanceWindow: Optional[String]
    def port: Optional[IntegerOptional]
    def notificationTopicArn: Optional[String]
    def autoMinorVersionUpgrade: Optional[BooleanOptional]
    def snapshotRetentionLimit: Optional[IntegerOptional]
    def snapshotWindow: Optional[String]
    def authToken: Optional[String]
    def transitEncryptionEnabled: Optional[BooleanOptional]
    def atRestEncryptionEnabled: Optional[BooleanOptional]
    def kmsKeyId: Optional[String]
    def userGroupIds: Optional[List[UserGroupId]]
    def logDeliveryConfigurations: Optional[
      List[zio.aws.elasticache.model.LogDeliveryConfigurationRequest.ReadOnly]
    ]
    def dataTieringEnabled: Optional[BooleanOptional]
    def networkType: Optional[zio.aws.elasticache.model.NetworkType]
    def ipDiscovery: Optional[zio.aws.elasticache.model.IpDiscovery]
    def transitEncryptionMode
        : Optional[zio.aws.elasticache.model.TransitEncryptionMode]
    def clusterMode: Optional[zio.aws.elasticache.model.ClusterMode]
    def getReplicationGroupId: ZIO[Any, Nothing, String] =
      ZIO.succeed(replicationGroupId)
    def getReplicationGroupDescription: ZIO[Any, Nothing, String] =
      ZIO.succeed(replicationGroupDescription)
    def getGlobalReplicationGroupId: ZIO[Any, AwsError, String] = AwsError
      .unwrapOptionField("globalReplicationGroupId", globalReplicationGroupId)
    def getPrimaryClusterId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("primaryClusterId", primaryClusterId)
    def getAutomaticFailoverEnabled: ZIO[Any, AwsError, BooleanOptional] =
      AwsError.unwrapOptionField(
        "automaticFailoverEnabled",
        automaticFailoverEnabled
      )
    def getMultiAZEnabled: ZIO[Any, AwsError, BooleanOptional] =
      AwsError.unwrapOptionField("multiAZEnabled", multiAZEnabled)
    def getNumCacheClusters: ZIO[Any, AwsError, IntegerOptional] =
      AwsError.unwrapOptionField("numCacheClusters", numCacheClusters)
    def getPreferredCacheClusterAZs: ZIO[Any, AwsError, List[String]] = AwsError
      .unwrapOptionField("preferredCacheClusterAZs", preferredCacheClusterAZs)
    def getNumNodeGroups: ZIO[Any, AwsError, IntegerOptional] =
      AwsError.unwrapOptionField("numNodeGroups", numNodeGroups)
    def getReplicasPerNodeGroup: ZIO[Any, AwsError, IntegerOptional] =
      AwsError.unwrapOptionField("replicasPerNodeGroup", replicasPerNodeGroup)
    def getNodeGroupConfiguration: ZIO[Any, AwsError, List[
      zio.aws.elasticache.model.NodeGroupConfiguration.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "nodeGroupConfiguration",
      nodeGroupConfiguration
    )
    def getCacheNodeType: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("cacheNodeType", cacheNodeType)
    def getEngine: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("engine", engine)
    def getEngineVersion: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("engineVersion", engineVersion)
    def getCacheParameterGroupName: ZIO[Any, AwsError, String] = AwsError
      .unwrapOptionField("cacheParameterGroupName", cacheParameterGroupName)
    def getCacheSubnetGroupName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("cacheSubnetGroupName", cacheSubnetGroupName)
    def getCacheSecurityGroupNames: ZIO[Any, AwsError, List[String]] = AwsError
      .unwrapOptionField("cacheSecurityGroupNames", cacheSecurityGroupNames)
    def getSecurityGroupIds: ZIO[Any, AwsError, List[String]] =
      AwsError.unwrapOptionField("securityGroupIds", securityGroupIds)
    def getTags
        : ZIO[Any, AwsError, List[zio.aws.elasticache.model.Tag.ReadOnly]] =
      AwsError.unwrapOptionField("tags", tags)
    def getSnapshotArns: ZIO[Any, AwsError, List[String]] =
      AwsError.unwrapOptionField("snapshotArns", snapshotArns)
    def getSnapshotName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("snapshotName", snapshotName)
    def getPreferredMaintenanceWindow: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField(
        "preferredMaintenanceWindow",
        preferredMaintenanceWindow
      )
    def getPort: ZIO[Any, AwsError, IntegerOptional] =
      AwsError.unwrapOptionField("port", port)
    def getNotificationTopicArn: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("notificationTopicArn", notificationTopicArn)
    def getAutoMinorVersionUpgrade: ZIO[Any, AwsError, BooleanOptional] =
      AwsError.unwrapOptionField(
        "autoMinorVersionUpgrade",
        autoMinorVersionUpgrade
      )
    def getSnapshotRetentionLimit: ZIO[Any, AwsError, IntegerOptional] =
      AwsError.unwrapOptionField(
        "snapshotRetentionLimit",
        snapshotRetentionLimit
      )
    def getSnapshotWindow: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("snapshotWindow", snapshotWindow)
    def getAuthToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("authToken", authToken)
    def getTransitEncryptionEnabled: ZIO[Any, AwsError, BooleanOptional] =
      AwsError.unwrapOptionField(
        "transitEncryptionEnabled",
        transitEncryptionEnabled
      )
    def getAtRestEncryptionEnabled: ZIO[Any, AwsError, BooleanOptional] =
      AwsError.unwrapOptionField(
        "atRestEncryptionEnabled",
        atRestEncryptionEnabled
      )
    def getKmsKeyId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("kmsKeyId", kmsKeyId)
    def getUserGroupIds: ZIO[Any, AwsError, List[UserGroupId]] =
      AwsError.unwrapOptionField("userGroupIds", userGroupIds)
    def getLogDeliveryConfigurations: ZIO[Any, AwsError, List[
      zio.aws.elasticache.model.LogDeliveryConfigurationRequest.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "logDeliveryConfigurations",
      logDeliveryConfigurations
    )
    def getDataTieringEnabled: ZIO[Any, AwsError, BooleanOptional] =
      AwsError.unwrapOptionField("dataTieringEnabled", dataTieringEnabled)
    def getNetworkType
        : ZIO[Any, AwsError, zio.aws.elasticache.model.NetworkType] =
      AwsError.unwrapOptionField("networkType", networkType)
    def getIpDiscovery
        : ZIO[Any, AwsError, zio.aws.elasticache.model.IpDiscovery] =
      AwsError.unwrapOptionField("ipDiscovery", ipDiscovery)
    def getTransitEncryptionMode
        : ZIO[Any, AwsError, zio.aws.elasticache.model.TransitEncryptionMode] =
      AwsError.unwrapOptionField("transitEncryptionMode", transitEncryptionMode)
    def getClusterMode
        : ZIO[Any, AwsError, zio.aws.elasticache.model.ClusterMode] =
      AwsError.unwrapOptionField("clusterMode", clusterMode)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.elasticache.model.CreateReplicationGroupRequest
  ) extends zio.aws.elasticache.model.CreateReplicationGroupRequest.ReadOnly {
    override val replicationGroupId: String = impl.replicationGroupId(): String
    override val replicationGroupDescription: String =
      impl.replicationGroupDescription(): String
    override val globalReplicationGroupId: Optional[String] =
      zio.aws.core.internal
        .optionalFromNullable(impl.globalReplicationGroupId())
        .map(value => value: String)
    override val primaryClusterId: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.primaryClusterId())
      .map(value => value: String)
    override val automaticFailoverEnabled: Optional[BooleanOptional] =
      zio.aws.core.internal
        .optionalFromNullable(impl.automaticFailoverEnabled())
        .map(value => value: BooleanOptional)
    override val multiAZEnabled: Optional[BooleanOptional] =
      zio.aws.core.internal
        .optionalFromNullable(impl.multiAZEnabled())
        .map(value => value: BooleanOptional)
    override val numCacheClusters: Optional[IntegerOptional] =
      zio.aws.core.internal
        .optionalFromNullable(impl.numCacheClusters())
        .map(value => value: IntegerOptional)
    override val preferredCacheClusterAZs: Optional[List[String]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.preferredCacheClusterAZs())
        .map(value =>
          value.asScala.map { item =>
            item: String
          }.toList
        )
    override val numNodeGroups: Optional[IntegerOptional] =
      zio.aws.core.internal
        .optionalFromNullable(impl.numNodeGroups())
        .map(value => value: IntegerOptional)
    override val replicasPerNodeGroup: Optional[IntegerOptional] =
      zio.aws.core.internal
        .optionalFromNullable(impl.replicasPerNodeGroup())
        .map(value => value: IntegerOptional)
    override val nodeGroupConfiguration: Optional[
      List[zio.aws.elasticache.model.NodeGroupConfiguration.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.nodeGroupConfiguration())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.elasticache.model.NodeGroupConfiguration.wrap(item)
        }.toList
      )
    override val cacheNodeType: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.cacheNodeType())
      .map(value => value: String)
    override val engine: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.engine())
      .map(value => value: String)
    override val engineVersion: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.engineVersion())
      .map(value => value: String)
    override val cacheParameterGroupName: Optional[String] =
      zio.aws.core.internal
        .optionalFromNullable(impl.cacheParameterGroupName())
        .map(value => value: String)
    override val cacheSubnetGroupName: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.cacheSubnetGroupName())
      .map(value => value: String)
    override val cacheSecurityGroupNames: Optional[List[String]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.cacheSecurityGroupNames())
        .map(value =>
          value.asScala.map { item =>
            item: String
          }.toList
        )
    override val securityGroupIds: Optional[List[String]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.securityGroupIds())
        .map(value =>
          value.asScala.map { item =>
            item: String
          }.toList
        )
    override val tags: Optional[List[zio.aws.elasticache.model.Tag.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.tags())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.elasticache.model.Tag.wrap(item)
          }.toList
        )
    override val snapshotArns: Optional[List[String]] = zio.aws.core.internal
      .optionalFromNullable(impl.snapshotArns())
      .map(value =>
        value.asScala.map { item =>
          item: String
        }.toList
      )
    override val snapshotName: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.snapshotName())
      .map(value => value: String)
    override val preferredMaintenanceWindow: Optional[String] =
      zio.aws.core.internal
        .optionalFromNullable(impl.preferredMaintenanceWindow())
        .map(value => value: String)
    override val port: Optional[IntegerOptional] = zio.aws.core.internal
      .optionalFromNullable(impl.port())
      .map(value => value: IntegerOptional)
    override val notificationTopicArn: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.notificationTopicArn())
      .map(value => value: String)
    override val autoMinorVersionUpgrade: Optional[BooleanOptional] =
      zio.aws.core.internal
        .optionalFromNullable(impl.autoMinorVersionUpgrade())
        .map(value => value: BooleanOptional)
    override val snapshotRetentionLimit: Optional[IntegerOptional] =
      zio.aws.core.internal
        .optionalFromNullable(impl.snapshotRetentionLimit())
        .map(value => value: IntegerOptional)
    override val snapshotWindow: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.snapshotWindow())
      .map(value => value: String)
    override val authToken: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.authToken())
      .map(value => value: String)
    override val transitEncryptionEnabled: Optional[BooleanOptional] =
      zio.aws.core.internal
        .optionalFromNullable(impl.transitEncryptionEnabled())
        .map(value => value: BooleanOptional)
    override val atRestEncryptionEnabled: Optional[BooleanOptional] =
      zio.aws.core.internal
        .optionalFromNullable(impl.atRestEncryptionEnabled())
        .map(value => value: BooleanOptional)
    override val kmsKeyId: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.kmsKeyId())
      .map(value => value: String)
    override val userGroupIds: Optional[List[UserGroupId]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.userGroupIds())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.elasticache.model.primitives.UserGroupId(item)
          }.toList
        )
    override val logDeliveryConfigurations: Optional[
      List[zio.aws.elasticache.model.LogDeliveryConfigurationRequest.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.logDeliveryConfigurations())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.elasticache.model.LogDeliveryConfigurationRequest.wrap(item)
        }.toList
      )
    override val dataTieringEnabled: Optional[BooleanOptional] =
      zio.aws.core.internal
        .optionalFromNullable(impl.dataTieringEnabled())
        .map(value => value: BooleanOptional)
    override val networkType: Optional[zio.aws.elasticache.model.NetworkType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.networkType())
        .map(value => zio.aws.elasticache.model.NetworkType.wrap(value))
    override val ipDiscovery: Optional[zio.aws.elasticache.model.IpDiscovery] =
      zio.aws.core.internal
        .optionalFromNullable(impl.ipDiscovery())
        .map(value => zio.aws.elasticache.model.IpDiscovery.wrap(value))
    override val transitEncryptionMode
        : Optional[zio.aws.elasticache.model.TransitEncryptionMode] =
      zio.aws.core.internal
        .optionalFromNullable(impl.transitEncryptionMode())
        .map(value =>
          zio.aws.elasticache.model.TransitEncryptionMode.wrap(value)
        )
    override val clusterMode: Optional[zio.aws.elasticache.model.ClusterMode] =
      zio.aws.core.internal
        .optionalFromNullable(impl.clusterMode())
        .map(value => zio.aws.elasticache.model.ClusterMode.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.elasticache.model.CreateReplicationGroupRequest
  ): zio.aws.elasticache.model.CreateReplicationGroupRequest.ReadOnly =
    new Wrapper(impl)
}
