package zio.aws.elasticache.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.elasticache.model.primitives.{Integer, TStamp}
import scala.jdk.CollectionConverters._
final case class ReservedCacheNode(
    reservedCacheNodeId: Optional[String] = Optional.Absent,
    reservedCacheNodesOfferingId: Optional[String] = Optional.Absent,
    cacheNodeType: Optional[String] = Optional.Absent,
    startTime: Optional[TStamp] = Optional.Absent,
    duration: Optional[Integer] = Optional.Absent,
    fixedPrice: Optional[Double] = Optional.Absent,
    usagePrice: Optional[Double] = Optional.Absent,
    cacheNodeCount: Optional[Integer] = Optional.Absent,
    productDescription: Optional[String] = Optional.Absent,
    offeringType: Optional[String] = Optional.Absent,
    state: Optional[String] = Optional.Absent,
    recurringCharges: Optional[
      Iterable[zio.aws.elasticache.model.RecurringCharge]
    ] = Optional.Absent,
    reservationARN: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.elasticache.model.ReservedCacheNode = {
    import ReservedCacheNode.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.elasticache.model.ReservedCacheNode
      .builder()
      .optionallyWith(
        reservedCacheNodeId.map(value => value: java.lang.String)
      )(_.reservedCacheNodeId)
      .optionallyWith(
        reservedCacheNodesOfferingId.map(value => value: java.lang.String)
      )(_.reservedCacheNodesOfferingId)
      .optionallyWith(cacheNodeType.map(value => value: java.lang.String))(
        _.cacheNodeType
      )
      .optionallyWith(startTime.map(value => TStamp.unwrap(value): Instant))(
        _.startTime
      )
      .optionallyWith(duration.map(value => value: java.lang.Integer))(
        _.duration
      )
      .optionallyWith(fixedPrice.map(value => value: java.lang.Double))(
        _.fixedPrice
      )
      .optionallyWith(usagePrice.map(value => value: java.lang.Double))(
        _.usagePrice
      )
      .optionallyWith(cacheNodeCount.map(value => value: java.lang.Integer))(
        _.cacheNodeCount
      )
      .optionallyWith(productDescription.map(value => value: java.lang.String))(
        _.productDescription
      )
      .optionallyWith(offeringType.map(value => value: java.lang.String))(
        _.offeringType
      )
      .optionallyWith(state.map(value => value: java.lang.String))(_.state)
      .optionallyWith(
        recurringCharges.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.recurringCharges)
      .optionallyWith(reservationARN.map(value => value: java.lang.String))(
        _.reservationARN
      )
      .build()
  }
  def asReadOnly: zio.aws.elasticache.model.ReservedCacheNode.ReadOnly =
    zio.aws.elasticache.model.ReservedCacheNode.wrap(buildAwsValue())
}
object ReservedCacheNode {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.elasticache.model.ReservedCacheNode
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.elasticache.model.ReservedCacheNode =
      zio.aws.elasticache.model.ReservedCacheNode(
        reservedCacheNodeId.map(value => value),
        reservedCacheNodesOfferingId.map(value => value),
        cacheNodeType.map(value => value),
        startTime.map(value => value),
        duration.map(value => value),
        fixedPrice.map(value => value),
        usagePrice.map(value => value),
        cacheNodeCount.map(value => value),
        productDescription.map(value => value),
        offeringType.map(value => value),
        state.map(value => value),
        recurringCharges.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        reservationARN.map(value => value)
      )
    def reservedCacheNodeId: Optional[String]
    def reservedCacheNodesOfferingId: Optional[String]
    def cacheNodeType: Optional[String]
    def startTime: Optional[TStamp]
    def duration: Optional[Integer]
    def fixedPrice: Optional[Double]
    def usagePrice: Optional[Double]
    def cacheNodeCount: Optional[Integer]
    def productDescription: Optional[String]
    def offeringType: Optional[String]
    def state: Optional[String]
    def recurringCharges
        : Optional[List[zio.aws.elasticache.model.RecurringCharge.ReadOnly]]
    def reservationARN: Optional[String]
    def getReservedCacheNodeId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("reservedCacheNodeId", reservedCacheNodeId)
    def getReservedCacheNodesOfferingId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField(
        "reservedCacheNodesOfferingId",
        reservedCacheNodesOfferingId
      )
    def getCacheNodeType: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("cacheNodeType", cacheNodeType)
    def getStartTime: ZIO[Any, AwsError, TStamp] =
      AwsError.unwrapOptionField("startTime", startTime)
    def getDuration: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("duration", duration)
    def getFixedPrice: ZIO[Any, AwsError, Double] =
      AwsError.unwrapOptionField("fixedPrice", fixedPrice)
    def getUsagePrice: ZIO[Any, AwsError, Double] =
      AwsError.unwrapOptionField("usagePrice", usagePrice)
    def getCacheNodeCount: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("cacheNodeCount", cacheNodeCount)
    def getProductDescription: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("productDescription", productDescription)
    def getOfferingType: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("offeringType", offeringType)
    def getState: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("state", state)
    def getRecurringCharges: ZIO[Any, AwsError, List[
      zio.aws.elasticache.model.RecurringCharge.ReadOnly
    ]] = AwsError.unwrapOptionField("recurringCharges", recurringCharges)
    def getReservationARN: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("reservationARN", reservationARN)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.elasticache.model.ReservedCacheNode
  ) extends zio.aws.elasticache.model.ReservedCacheNode.ReadOnly {
    override val reservedCacheNodeId: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.reservedCacheNodeId())
      .map(value => value: String)
    override val reservedCacheNodesOfferingId: Optional[String] =
      zio.aws.core.internal
        .optionalFromNullable(impl.reservedCacheNodesOfferingId())
        .map(value => value: String)
    override val cacheNodeType: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.cacheNodeType())
      .map(value => value: String)
    override val startTime: Optional[TStamp] = zio.aws.core.internal
      .optionalFromNullable(impl.startTime())
      .map(value => zio.aws.elasticache.model.primitives.TStamp(value))
    override val duration: Optional[Integer] = zio.aws.core.internal
      .optionalFromNullable(impl.duration())
      .map(value => value: Integer)
    override val fixedPrice: Optional[Double] = zio.aws.core.internal
      .optionalFromNullable(impl.fixedPrice())
      .map(value => value: Double)
    override val usagePrice: Optional[Double] = zio.aws.core.internal
      .optionalFromNullable(impl.usagePrice())
      .map(value => value: Double)
    override val cacheNodeCount: Optional[Integer] = zio.aws.core.internal
      .optionalFromNullable(impl.cacheNodeCount())
      .map(value => value: Integer)
    override val productDescription: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.productDescription())
      .map(value => value: String)
    override val offeringType: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.offeringType())
      .map(value => value: String)
    override val state: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.state())
      .map(value => value: String)
    override val recurringCharges
        : Optional[List[zio.aws.elasticache.model.RecurringCharge.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.recurringCharges())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.elasticache.model.RecurringCharge.wrap(item)
          }.toList
        )
    override val reservationARN: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.reservationARN())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.elasticache.model.ReservedCacheNode
  ): zio.aws.elasticache.model.ReservedCacheNode.ReadOnly = new Wrapper(impl)
}
