package zio.aws.elasticache.model
import zio.aws.elasticache.model.primitives.{FilterValue, FilterName}
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class Filter(name: FilterName, values: Iterable[FilterValue]) {
  def buildAwsValue()
      : software.amazon.awssdk.services.elasticache.model.Filter = {
    import Filter.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.elasticache.model.Filter
      .builder()
      .name(FilterName.unwrap(name): java.lang.String)
      .values(values.map { item =>
        FilterValue.unwrap(item): java.lang.String
      }.asJavaCollection)
      .build()
  }
  def asReadOnly: zio.aws.elasticache.model.Filter.ReadOnly =
    zio.aws.elasticache.model.Filter.wrap(buildAwsValue())
}
object Filter {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.elasticache.model.Filter
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.elasticache.model.Filter =
      zio.aws.elasticache.model.Filter(name, values)
    def name: FilterName
    def values: List[FilterValue]
    def getName: ZIO[Any, Nothing, FilterName] = ZIO.succeed(name)
    def getValues: ZIO[Any, Nothing, List[FilterValue]] = ZIO.succeed(values)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.elasticache.model.Filter
  ) extends zio.aws.elasticache.model.Filter.ReadOnly {
    override val name: FilterName =
      zio.aws.elasticache.model.primitives.FilterName(impl.name())
    override val values: List[FilterValue] = impl
      .values()
      .asScala
      .map { item =>
        zio.aws.elasticache.model.primitives.FilterValue(item)
      }
      .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.elasticache.model.Filter
  ): zio.aws.elasticache.model.Filter.ReadOnly = new Wrapper(impl)
}
