package zio.aws.elasticache.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class DescribeReplicationGroupsResponse(
    marker: Optional[String] = Optional.Absent,
    replicationGroups: Optional[
      Iterable[zio.aws.elasticache.model.ReplicationGroup]
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.elasticache.model.DescribeReplicationGroupsResponse = {
    import DescribeReplicationGroupsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.elasticache.model.DescribeReplicationGroupsResponse
      .builder()
      .optionallyWith(marker.map(value => value: java.lang.String))(_.marker)
      .optionallyWith(
        replicationGroups.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.replicationGroups)
      .build()
  }
  def asReadOnly
      : zio.aws.elasticache.model.DescribeReplicationGroupsResponse.ReadOnly =
    zio.aws.elasticache.model.DescribeReplicationGroupsResponse
      .wrap(buildAwsValue())
}
object DescribeReplicationGroupsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.elasticache.model.DescribeReplicationGroupsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.elasticache.model.DescribeReplicationGroupsResponse =
      zio.aws.elasticache.model.DescribeReplicationGroupsResponse(
        marker.map(value => value),
        replicationGroups.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def marker: Optional[String]
    def replicationGroups
        : Optional[List[zio.aws.elasticache.model.ReplicationGroup.ReadOnly]]
    def getMarker: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("marker", marker)
    def getReplicationGroups: ZIO[Any, AwsError, List[
      zio.aws.elasticache.model.ReplicationGroup.ReadOnly
    ]] = AwsError.unwrapOptionField("replicationGroups", replicationGroups)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.elasticache.model.DescribeReplicationGroupsResponse
  ) extends zio.aws.elasticache.model.DescribeReplicationGroupsResponse.ReadOnly {
    override val marker: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.marker())
      .map(value => value: String)
    override val replicationGroups
        : Optional[List[zio.aws.elasticache.model.ReplicationGroup.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.replicationGroups())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.elasticache.model.ReplicationGroup.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.elasticache.model.DescribeReplicationGroupsResponse
  ): zio.aws.elasticache.model.DescribeReplicationGroupsResponse.ReadOnly =
    new Wrapper(impl)
}
