package zio.aws.elasticache.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.elasticache.model.primitives.{TStamp, IntegerOptional}
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class Snapshot(
    snapshotName: Optional[String] = Optional.Absent,
    replicationGroupId: Optional[String] = Optional.Absent,
    replicationGroupDescription: Optional[String] = Optional.Absent,
    cacheClusterId: Optional[String] = Optional.Absent,
    snapshotStatus: Optional[String] = Optional.Absent,
    snapshotSource: Optional[String] = Optional.Absent,
    cacheNodeType: Optional[String] = Optional.Absent,
    engine: Optional[String] = Optional.Absent,
    engineVersion: Optional[String] = Optional.Absent,
    numCacheNodes: Optional[IntegerOptional] = Optional.Absent,
    preferredAvailabilityZone: Optional[String] = Optional.Absent,
    preferredOutpostArn: Optional[String] = Optional.Absent,
    cacheClusterCreateTime: Optional[TStamp] = Optional.Absent,
    preferredMaintenanceWindow: Optional[String] = Optional.Absent,
    topicArn: Optional[String] = Optional.Absent,
    port: Optional[IntegerOptional] = Optional.Absent,
    cacheParameterGroupName: Optional[String] = Optional.Absent,
    cacheSubnetGroupName: Optional[String] = Optional.Absent,
    vpcId: Optional[String] = Optional.Absent,
    autoMinorVersionUpgrade: Optional[Boolean] = Optional.Absent,
    snapshotRetentionLimit: Optional[IntegerOptional] = Optional.Absent,
    snapshotWindow: Optional[String] = Optional.Absent,
    numNodeGroups: Optional[IntegerOptional] = Optional.Absent,
    automaticFailover: Optional[
      zio.aws.elasticache.model.AutomaticFailoverStatus
    ] = Optional.Absent,
    nodeSnapshots: Optional[Iterable[zio.aws.elasticache.model.NodeSnapshot]] =
      Optional.Absent,
    kmsKeyId: Optional[String] = Optional.Absent,
    arn: Optional[String] = Optional.Absent,
    dataTiering: Optional[zio.aws.elasticache.model.DataTieringStatus] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.elasticache.model.Snapshot = {
    import Snapshot.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.elasticache.model.Snapshot
      .builder()
      .optionallyWith(snapshotName.map(value => value: java.lang.String))(
        _.snapshotName
      )
      .optionallyWith(replicationGroupId.map(value => value: java.lang.String))(
        _.replicationGroupId
      )
      .optionallyWith(
        replicationGroupDescription.map(value => value: java.lang.String)
      )(_.replicationGroupDescription)
      .optionallyWith(cacheClusterId.map(value => value: java.lang.String))(
        _.cacheClusterId
      )
      .optionallyWith(snapshotStatus.map(value => value: java.lang.String))(
        _.snapshotStatus
      )
      .optionallyWith(snapshotSource.map(value => value: java.lang.String))(
        _.snapshotSource
      )
      .optionallyWith(cacheNodeType.map(value => value: java.lang.String))(
        _.cacheNodeType
      )
      .optionallyWith(engine.map(value => value: java.lang.String))(_.engine)
      .optionallyWith(engineVersion.map(value => value: java.lang.String))(
        _.engineVersion
      )
      .optionallyWith(numCacheNodes.map(value => value: Integer))(
        _.numCacheNodes
      )
      .optionallyWith(
        preferredAvailabilityZone.map(value => value: java.lang.String)
      )(_.preferredAvailabilityZone)
      .optionallyWith(
        preferredOutpostArn.map(value => value: java.lang.String)
      )(_.preferredOutpostArn)
      .optionallyWith(
        cacheClusterCreateTime.map(value => TStamp.unwrap(value): Instant)
      )(_.cacheClusterCreateTime)
      .optionallyWith(
        preferredMaintenanceWindow.map(value => value: java.lang.String)
      )(_.preferredMaintenanceWindow)
      .optionallyWith(topicArn.map(value => value: java.lang.String))(
        _.topicArn
      )
      .optionallyWith(port.map(value => value: Integer))(_.port)
      .optionallyWith(
        cacheParameterGroupName.map(value => value: java.lang.String)
      )(_.cacheParameterGroupName)
      .optionallyWith(
        cacheSubnetGroupName.map(value => value: java.lang.String)
      )(_.cacheSubnetGroupName)
      .optionallyWith(vpcId.map(value => value: java.lang.String))(_.vpcId)
      .optionallyWith(
        autoMinorVersionUpgrade.map(value => value: java.lang.Boolean)
      )(_.autoMinorVersionUpgrade)
      .optionallyWith(snapshotRetentionLimit.map(value => value: Integer))(
        _.snapshotRetentionLimit
      )
      .optionallyWith(snapshotWindow.map(value => value: java.lang.String))(
        _.snapshotWindow
      )
      .optionallyWith(numNodeGroups.map(value => value: Integer))(
        _.numNodeGroups
      )
      .optionallyWith(automaticFailover.map(value => value.unwrap))(
        _.automaticFailover
      )
      .optionallyWith(
        nodeSnapshots.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.nodeSnapshots)
      .optionallyWith(kmsKeyId.map(value => value: java.lang.String))(
        _.kmsKeyId
      )
      .optionallyWith(arn.map(value => value: java.lang.String))(_.arn)
      .optionallyWith(dataTiering.map(value => value.unwrap))(_.dataTiering)
      .build()
  }
  def asReadOnly: zio.aws.elasticache.model.Snapshot.ReadOnly =
    zio.aws.elasticache.model.Snapshot.wrap(buildAwsValue())
}
object Snapshot {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.elasticache.model.Snapshot
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.elasticache.model.Snapshot =
      zio.aws.elasticache.model.Snapshot(
        snapshotName.map(value => value),
        replicationGroupId.map(value => value),
        replicationGroupDescription.map(value => value),
        cacheClusterId.map(value => value),
        snapshotStatus.map(value => value),
        snapshotSource.map(value => value),
        cacheNodeType.map(value => value),
        engine.map(value => value),
        engineVersion.map(value => value),
        numCacheNodes.map(value => value),
        preferredAvailabilityZone.map(value => value),
        preferredOutpostArn.map(value => value),
        cacheClusterCreateTime.map(value => value),
        preferredMaintenanceWindow.map(value => value),
        topicArn.map(value => value),
        port.map(value => value),
        cacheParameterGroupName.map(value => value),
        cacheSubnetGroupName.map(value => value),
        vpcId.map(value => value),
        autoMinorVersionUpgrade.map(value => value),
        snapshotRetentionLimit.map(value => value),
        snapshotWindow.map(value => value),
        numNodeGroups.map(value => value),
        automaticFailover.map(value => value),
        nodeSnapshots.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        kmsKeyId.map(value => value),
        arn.map(value => value),
        dataTiering.map(value => value)
      )
    def snapshotName: Optional[String]
    def replicationGroupId: Optional[String]
    def replicationGroupDescription: Optional[String]
    def cacheClusterId: Optional[String]
    def snapshotStatus: Optional[String]
    def snapshotSource: Optional[String]
    def cacheNodeType: Optional[String]
    def engine: Optional[String]
    def engineVersion: Optional[String]
    def numCacheNodes: Optional[IntegerOptional]
    def preferredAvailabilityZone: Optional[String]
    def preferredOutpostArn: Optional[String]
    def cacheClusterCreateTime: Optional[TStamp]
    def preferredMaintenanceWindow: Optional[String]
    def topicArn: Optional[String]
    def port: Optional[IntegerOptional]
    def cacheParameterGroupName: Optional[String]
    def cacheSubnetGroupName: Optional[String]
    def vpcId: Optional[String]
    def autoMinorVersionUpgrade: Optional[Boolean]
    def snapshotRetentionLimit: Optional[IntegerOptional]
    def snapshotWindow: Optional[String]
    def numNodeGroups: Optional[IntegerOptional]
    def automaticFailover
        : Optional[zio.aws.elasticache.model.AutomaticFailoverStatus]
    def nodeSnapshots
        : Optional[List[zio.aws.elasticache.model.NodeSnapshot.ReadOnly]]
    def kmsKeyId: Optional[String]
    def arn: Optional[String]
    def dataTiering: Optional[zio.aws.elasticache.model.DataTieringStatus]
    def getSnapshotName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("snapshotName", snapshotName)
    def getReplicationGroupId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("replicationGroupId", replicationGroupId)
    def getReplicationGroupDescription: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField(
        "replicationGroupDescription",
        replicationGroupDescription
      )
    def getCacheClusterId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("cacheClusterId", cacheClusterId)
    def getSnapshotStatus: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("snapshotStatus", snapshotStatus)
    def getSnapshotSource: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("snapshotSource", snapshotSource)
    def getCacheNodeType: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("cacheNodeType", cacheNodeType)
    def getEngine: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("engine", engine)
    def getEngineVersion: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("engineVersion", engineVersion)
    def getNumCacheNodes: ZIO[Any, AwsError, IntegerOptional] =
      AwsError.unwrapOptionField("numCacheNodes", numCacheNodes)
    def getPreferredAvailabilityZone: ZIO[Any, AwsError, String] = AwsError
      .unwrapOptionField("preferredAvailabilityZone", preferredAvailabilityZone)
    def getPreferredOutpostArn: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("preferredOutpostArn", preferredOutpostArn)
    def getCacheClusterCreateTime: ZIO[Any, AwsError, TStamp] = AwsError
      .unwrapOptionField("cacheClusterCreateTime", cacheClusterCreateTime)
    def getPreferredMaintenanceWindow: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField(
        "preferredMaintenanceWindow",
        preferredMaintenanceWindow
      )
    def getTopicArn: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("topicArn", topicArn)
    def getPort: ZIO[Any, AwsError, IntegerOptional] =
      AwsError.unwrapOptionField("port", port)
    def getCacheParameterGroupName: ZIO[Any, AwsError, String] = AwsError
      .unwrapOptionField("cacheParameterGroupName", cacheParameterGroupName)
    def getCacheSubnetGroupName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("cacheSubnetGroupName", cacheSubnetGroupName)
    def getVpcId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("vpcId", vpcId)
    def getAutoMinorVersionUpgrade: ZIO[Any, AwsError, Boolean] = AwsError
      .unwrapOptionField("autoMinorVersionUpgrade", autoMinorVersionUpgrade)
    def getSnapshotRetentionLimit: ZIO[Any, AwsError, IntegerOptional] =
      AwsError.unwrapOptionField(
        "snapshotRetentionLimit",
        snapshotRetentionLimit
      )
    def getSnapshotWindow: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("snapshotWindow", snapshotWindow)
    def getNumNodeGroups: ZIO[Any, AwsError, IntegerOptional] =
      AwsError.unwrapOptionField("numNodeGroups", numNodeGroups)
    def getAutomaticFailover: ZIO[
      Any,
      AwsError,
      zio.aws.elasticache.model.AutomaticFailoverStatus
    ] = AwsError.unwrapOptionField("automaticFailover", automaticFailover)
    def getNodeSnapshots: ZIO[Any, AwsError, List[
      zio.aws.elasticache.model.NodeSnapshot.ReadOnly
    ]] = AwsError.unwrapOptionField("nodeSnapshots", nodeSnapshots)
    def getKmsKeyId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("kmsKeyId", kmsKeyId)
    def getArn: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("arn", arn)
    def getDataTiering
        : ZIO[Any, AwsError, zio.aws.elasticache.model.DataTieringStatus] =
      AwsError.unwrapOptionField("dataTiering", dataTiering)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.elasticache.model.Snapshot
  ) extends zio.aws.elasticache.model.Snapshot.ReadOnly {
    override val snapshotName: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.snapshotName())
      .map(value => value: String)
    override val replicationGroupId: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.replicationGroupId())
      .map(value => value: String)
    override val replicationGroupDescription: Optional[String] =
      zio.aws.core.internal
        .optionalFromNullable(impl.replicationGroupDescription())
        .map(value => value: String)
    override val cacheClusterId: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.cacheClusterId())
      .map(value => value: String)
    override val snapshotStatus: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.snapshotStatus())
      .map(value => value: String)
    override val snapshotSource: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.snapshotSource())
      .map(value => value: String)
    override val cacheNodeType: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.cacheNodeType())
      .map(value => value: String)
    override val engine: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.engine())
      .map(value => value: String)
    override val engineVersion: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.engineVersion())
      .map(value => value: String)
    override val numCacheNodes: Optional[IntegerOptional] =
      zio.aws.core.internal
        .optionalFromNullable(impl.numCacheNodes())
        .map(value => value: IntegerOptional)
    override val preferredAvailabilityZone: Optional[String] =
      zio.aws.core.internal
        .optionalFromNullable(impl.preferredAvailabilityZone())
        .map(value => value: String)
    override val preferredOutpostArn: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.preferredOutpostArn())
      .map(value => value: String)
    override val cacheClusterCreateTime: Optional[TStamp] =
      zio.aws.core.internal
        .optionalFromNullable(impl.cacheClusterCreateTime())
        .map(value => zio.aws.elasticache.model.primitives.TStamp(value))
    override val preferredMaintenanceWindow: Optional[String] =
      zio.aws.core.internal
        .optionalFromNullable(impl.preferredMaintenanceWindow())
        .map(value => value: String)
    override val topicArn: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.topicArn())
      .map(value => value: String)
    override val port: Optional[IntegerOptional] = zio.aws.core.internal
      .optionalFromNullable(impl.port())
      .map(value => value: IntegerOptional)
    override val cacheParameterGroupName: Optional[String] =
      zio.aws.core.internal
        .optionalFromNullable(impl.cacheParameterGroupName())
        .map(value => value: String)
    override val cacheSubnetGroupName: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.cacheSubnetGroupName())
      .map(value => value: String)
    override val vpcId: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.vpcId())
      .map(value => value: String)
    override val autoMinorVersionUpgrade: Optional[Boolean] =
      zio.aws.core.internal
        .optionalFromNullable(impl.autoMinorVersionUpgrade())
        .map(value => value: Boolean)
    override val snapshotRetentionLimit: Optional[IntegerOptional] =
      zio.aws.core.internal
        .optionalFromNullable(impl.snapshotRetentionLimit())
        .map(value => value: IntegerOptional)
    override val snapshotWindow: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.snapshotWindow())
      .map(value => value: String)
    override val numNodeGroups: Optional[IntegerOptional] =
      zio.aws.core.internal
        .optionalFromNullable(impl.numNodeGroups())
        .map(value => value: IntegerOptional)
    override val automaticFailover
        : Optional[zio.aws.elasticache.model.AutomaticFailoverStatus] =
      zio.aws.core.internal
        .optionalFromNullable(impl.automaticFailover())
        .map(value =>
          zio.aws.elasticache.model.AutomaticFailoverStatus.wrap(value)
        )
    override val nodeSnapshots
        : Optional[List[zio.aws.elasticache.model.NodeSnapshot.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.nodeSnapshots())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.elasticache.model.NodeSnapshot.wrap(item)
          }.toList
        )
    override val kmsKeyId: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.kmsKeyId())
      .map(value => value: String)
    override val arn: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.arn())
      .map(value => value: String)
    override val dataTiering
        : Optional[zio.aws.elasticache.model.DataTieringStatus] =
      zio.aws.core.internal
        .optionalFromNullable(impl.dataTiering())
        .map(value => zio.aws.elasticache.model.DataTieringStatus.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.elasticache.model.Snapshot
  ): zio.aws.elasticache.model.Snapshot.ReadOnly = new Wrapper(impl)
}
