package zio.aws.elasticache.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.elasticache.model.primitives.{BooleanOptional, IntegerOptional}
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class PendingModifiedValues(
    numCacheNodes: Optional[IntegerOptional] = Optional.Absent,
    cacheNodeIdsToRemove: Optional[Iterable[String]] = Optional.Absent,
    engineVersion: Optional[String] = Optional.Absent,
    cacheNodeType: Optional[String] = Optional.Absent,
    authTokenStatus: Optional[zio.aws.elasticache.model.AuthTokenUpdateStatus] =
      Optional.Absent,
    logDeliveryConfigurations: Optional[
      Iterable[zio.aws.elasticache.model.PendingLogDeliveryConfiguration]
    ] = Optional.Absent,
    transitEncryptionEnabled: Optional[BooleanOptional] = Optional.Absent,
    transitEncryptionMode: Optional[
      zio.aws.elasticache.model.TransitEncryptionMode
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.elasticache.model.PendingModifiedValues = {
    import PendingModifiedValues.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.elasticache.model.PendingModifiedValues
      .builder()
      .optionallyWith(numCacheNodes.map(value => value: Integer))(
        _.numCacheNodes
      )
      .optionallyWith(
        cacheNodeIdsToRemove.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.cacheNodeIdsToRemove)
      .optionallyWith(engineVersion.map(value => value: java.lang.String))(
        _.engineVersion
      )
      .optionallyWith(cacheNodeType.map(value => value: java.lang.String))(
        _.cacheNodeType
      )
      .optionallyWith(authTokenStatus.map(value => value.unwrap))(
        _.authTokenStatus
      )
      .optionallyWith(
        logDeliveryConfigurations.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.logDeliveryConfigurations)
      .optionallyWith(
        transitEncryptionEnabled.map(value => value: java.lang.Boolean)
      )(_.transitEncryptionEnabled)
      .optionallyWith(transitEncryptionMode.map(value => value.unwrap))(
        _.transitEncryptionMode
      )
      .build()
  }
  def asReadOnly: zio.aws.elasticache.model.PendingModifiedValues.ReadOnly =
    zio.aws.elasticache.model.PendingModifiedValues.wrap(buildAwsValue())
}
object PendingModifiedValues {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.elasticache.model.PendingModifiedValues
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.elasticache.model.PendingModifiedValues =
      zio.aws.elasticache.model.PendingModifiedValues(
        numCacheNodes.map(value => value),
        cacheNodeIdsToRemove.map(value => value),
        engineVersion.map(value => value),
        cacheNodeType.map(value => value),
        authTokenStatus.map(value => value),
        logDeliveryConfigurations.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        transitEncryptionEnabled.map(value => value),
        transitEncryptionMode.map(value => value)
      )
    def numCacheNodes: Optional[IntegerOptional]
    def cacheNodeIdsToRemove: Optional[List[String]]
    def engineVersion: Optional[String]
    def cacheNodeType: Optional[String]
    def authTokenStatus
        : Optional[zio.aws.elasticache.model.AuthTokenUpdateStatus]
    def logDeliveryConfigurations: Optional[
      List[zio.aws.elasticache.model.PendingLogDeliveryConfiguration.ReadOnly]
    ]
    def transitEncryptionEnabled: Optional[BooleanOptional]
    def transitEncryptionMode
        : Optional[zio.aws.elasticache.model.TransitEncryptionMode]
    def getNumCacheNodes: ZIO[Any, AwsError, IntegerOptional] =
      AwsError.unwrapOptionField("numCacheNodes", numCacheNodes)
    def getCacheNodeIdsToRemove: ZIO[Any, AwsError, List[String]] =
      AwsError.unwrapOptionField("cacheNodeIdsToRemove", cacheNodeIdsToRemove)
    def getEngineVersion: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("engineVersion", engineVersion)
    def getCacheNodeType: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("cacheNodeType", cacheNodeType)
    def getAuthTokenStatus
        : ZIO[Any, AwsError, zio.aws.elasticache.model.AuthTokenUpdateStatus] =
      AwsError.unwrapOptionField("authTokenStatus", authTokenStatus)
    def getLogDeliveryConfigurations: ZIO[Any, AwsError, List[
      zio.aws.elasticache.model.PendingLogDeliveryConfiguration.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "logDeliveryConfigurations",
      logDeliveryConfigurations
    )
    def getTransitEncryptionEnabled: ZIO[Any, AwsError, BooleanOptional] =
      AwsError.unwrapOptionField(
        "transitEncryptionEnabled",
        transitEncryptionEnabled
      )
    def getTransitEncryptionMode
        : ZIO[Any, AwsError, zio.aws.elasticache.model.TransitEncryptionMode] =
      AwsError.unwrapOptionField("transitEncryptionMode", transitEncryptionMode)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.elasticache.model.PendingModifiedValues
  ) extends zio.aws.elasticache.model.PendingModifiedValues.ReadOnly {
    override val numCacheNodes: Optional[IntegerOptional] =
      zio.aws.core.internal
        .optionalFromNullable(impl.numCacheNodes())
        .map(value => value: IntegerOptional)
    override val cacheNodeIdsToRemove: Optional[List[String]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.cacheNodeIdsToRemove())
        .map(value =>
          value.asScala.map { item =>
            item: String
          }.toList
        )
    override val engineVersion: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.engineVersion())
      .map(value => value: String)
    override val cacheNodeType: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.cacheNodeType())
      .map(value => value: String)
    override val authTokenStatus
        : Optional[zio.aws.elasticache.model.AuthTokenUpdateStatus] =
      zio.aws.core.internal
        .optionalFromNullable(impl.authTokenStatus())
        .map(value =>
          zio.aws.elasticache.model.AuthTokenUpdateStatus.wrap(value)
        )
    override val logDeliveryConfigurations: Optional[
      List[zio.aws.elasticache.model.PendingLogDeliveryConfiguration.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.logDeliveryConfigurations())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.elasticache.model.PendingLogDeliveryConfiguration.wrap(item)
        }.toList
      )
    override val transitEncryptionEnabled: Optional[BooleanOptional] =
      zio.aws.core.internal
        .optionalFromNullable(impl.transitEncryptionEnabled())
        .map(value => value: BooleanOptional)
    override val transitEncryptionMode
        : Optional[zio.aws.elasticache.model.TransitEncryptionMode] =
      zio.aws.core.internal
        .optionalFromNullable(impl.transitEncryptionMode())
        .map(value =>
          zio.aws.elasticache.model.TransitEncryptionMode.wrap(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.elasticache.model.PendingModifiedValues
  ): zio.aws.elasticache.model.PendingModifiedValues.ReadOnly = new Wrapper(
    impl
  )
}
