package zio.aws.elasticache.model
import scala.jdk.CollectionConverters._
sealed trait IpDiscovery {
  def unwrap: software.amazon.awssdk.services.elasticache.model.IpDiscovery
}
object IpDiscovery {
  def wrap(
      value: software.amazon.awssdk.services.elasticache.model.IpDiscovery
  ): zio.aws.elasticache.model.IpDiscovery = value match {
    case software.amazon.awssdk.services.elasticache.model.IpDiscovery.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.elasticache.model.IpDiscovery.IPV4 =>
      val r = ipv4
      r
    case software.amazon.awssdk.services.elasticache.model.IpDiscovery.IPV6 =>
      val r = ipv6
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.elasticache.model.IpDiscovery {
    override def unwrap
        : software.amazon.awssdk.services.elasticache.model.IpDiscovery =
      software.amazon.awssdk.services.elasticache.model.IpDiscovery.UNKNOWN_TO_SDK_VERSION
  }
  case object ipv4 extends zio.aws.elasticache.model.IpDiscovery {
    override def unwrap
        : software.amazon.awssdk.services.elasticache.model.IpDiscovery =
      software.amazon.awssdk.services.elasticache.model.IpDiscovery.IPV4
  }
  case object ipv6 extends zio.aws.elasticache.model.IpDiscovery {
    override def unwrap
        : software.amazon.awssdk.services.elasticache.model.IpDiscovery =
      software.amazon.awssdk.services.elasticache.model.IpDiscovery.IPV6
  }
}
