package zio.aws.elasticache.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.elasticache.model.primitives.{
  IntegerOptional,
  AllowedNodeGroupId
}
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class NodeGroupConfiguration(
    nodeGroupId: Optional[AllowedNodeGroupId] = Optional.Absent,
    slots: Optional[String] = Optional.Absent,
    replicaCount: Optional[IntegerOptional] = Optional.Absent,
    primaryAvailabilityZone: Optional[String] = Optional.Absent,
    replicaAvailabilityZones: Optional[Iterable[String]] = Optional.Absent,
    primaryOutpostArn: Optional[String] = Optional.Absent,
    replicaOutpostArns: Optional[Iterable[String]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.elasticache.model.NodeGroupConfiguration = {
    import NodeGroupConfiguration.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.elasticache.model.NodeGroupConfiguration
      .builder()
      .optionallyWith(
        nodeGroupId.map(value =>
          AllowedNodeGroupId.unwrap(value): java.lang.String
        )
      )(_.nodeGroupId)
      .optionallyWith(slots.map(value => value: java.lang.String))(_.slots)
      .optionallyWith(replicaCount.map(value => value: Integer))(_.replicaCount)
      .optionallyWith(
        primaryAvailabilityZone.map(value => value: java.lang.String)
      )(_.primaryAvailabilityZone)
      .optionallyWith(
        replicaAvailabilityZones.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.replicaAvailabilityZones)
      .optionallyWith(primaryOutpostArn.map(value => value: java.lang.String))(
        _.primaryOutpostArn
      )
      .optionallyWith(
        replicaOutpostArns.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.replicaOutpostArns)
      .build()
  }
  def asReadOnly: zio.aws.elasticache.model.NodeGroupConfiguration.ReadOnly =
    zio.aws.elasticache.model.NodeGroupConfiguration.wrap(buildAwsValue())
}
object NodeGroupConfiguration {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.elasticache.model.NodeGroupConfiguration
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.elasticache.model.NodeGroupConfiguration =
      zio.aws.elasticache.model.NodeGroupConfiguration(
        nodeGroupId.map(value => value),
        slots.map(value => value),
        replicaCount.map(value => value),
        primaryAvailabilityZone.map(value => value),
        replicaAvailabilityZones.map(value => value),
        primaryOutpostArn.map(value => value),
        replicaOutpostArns.map(value => value)
      )
    def nodeGroupId: Optional[AllowedNodeGroupId]
    def slots: Optional[String]
    def replicaCount: Optional[IntegerOptional]
    def primaryAvailabilityZone: Optional[String]
    def replicaAvailabilityZones: Optional[List[String]]
    def primaryOutpostArn: Optional[String]
    def replicaOutpostArns: Optional[List[String]]
    def getNodeGroupId: ZIO[Any, AwsError, AllowedNodeGroupId] =
      AwsError.unwrapOptionField("nodeGroupId", nodeGroupId)
    def getSlots: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("slots", slots)
    def getReplicaCount: ZIO[Any, AwsError, IntegerOptional] =
      AwsError.unwrapOptionField("replicaCount", replicaCount)
    def getPrimaryAvailabilityZone: ZIO[Any, AwsError, String] = AwsError
      .unwrapOptionField("primaryAvailabilityZone", primaryAvailabilityZone)
    def getReplicaAvailabilityZones: ZIO[Any, AwsError, List[String]] = AwsError
      .unwrapOptionField("replicaAvailabilityZones", replicaAvailabilityZones)
    def getPrimaryOutpostArn: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("primaryOutpostArn", primaryOutpostArn)
    def getReplicaOutpostArns: ZIO[Any, AwsError, List[String]] =
      AwsError.unwrapOptionField("replicaOutpostArns", replicaOutpostArns)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.elasticache.model.NodeGroupConfiguration
  ) extends zio.aws.elasticache.model.NodeGroupConfiguration.ReadOnly {
    override val nodeGroupId: Optional[AllowedNodeGroupId] =
      zio.aws.core.internal
        .optionalFromNullable(impl.nodeGroupId())
        .map(value =>
          zio.aws.elasticache.model.primitives.AllowedNodeGroupId(value)
        )
    override val slots: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.slots())
      .map(value => value: String)
    override val replicaCount: Optional[IntegerOptional] = zio.aws.core.internal
      .optionalFromNullable(impl.replicaCount())
      .map(value => value: IntegerOptional)
    override val primaryAvailabilityZone: Optional[String] =
      zio.aws.core.internal
        .optionalFromNullable(impl.primaryAvailabilityZone())
        .map(value => value: String)
    override val replicaAvailabilityZones: Optional[List[String]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.replicaAvailabilityZones())
        .map(value =>
          value.asScala.map { item =>
            item: String
          }.toList
        )
    override val primaryOutpostArn: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.primaryOutpostArn())
      .map(value => value: String)
    override val replicaOutpostArns: Optional[List[String]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.replicaOutpostArns())
        .map(value =>
          value.asScala.map { item =>
            item: String
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.elasticache.model.NodeGroupConfiguration
  ): zio.aws.elasticache.model.NodeGroupConfiguration.ReadOnly = new Wrapper(
    impl
  )
}
