package zio.aws.elasticache.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.elasticache.model.primitives.TStamp
import scala.jdk.CollectionConverters._
final case class Event(
    sourceIdentifier: Optional[String] = Optional.Absent,
    sourceType: Optional[zio.aws.elasticache.model.SourceType] =
      Optional.Absent,
    message: Optional[String] = Optional.Absent,
    date: Optional[TStamp] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.elasticache.model.Event = {
    import Event.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.elasticache.model.Event
      .builder()
      .optionallyWith(sourceIdentifier.map(value => value: java.lang.String))(
        _.sourceIdentifier
      )
      .optionallyWith(sourceType.map(value => value.unwrap))(_.sourceType)
      .optionallyWith(message.map(value => value: java.lang.String))(_.message)
      .optionallyWith(date.map(value => TStamp.unwrap(value): Instant))(_.date)
      .build()
  }
  def asReadOnly: zio.aws.elasticache.model.Event.ReadOnly =
    zio.aws.elasticache.model.Event.wrap(buildAwsValue())
}
object Event {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.elasticache.model.Event] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.elasticache.model.Event =
      zio.aws.elasticache.model.Event(
        sourceIdentifier.map(value => value),
        sourceType.map(value => value),
        message.map(value => value),
        date.map(value => value)
      )
    def sourceIdentifier: Optional[String]
    def sourceType: Optional[zio.aws.elasticache.model.SourceType]
    def message: Optional[String]
    def date: Optional[TStamp]
    def getSourceIdentifier: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("sourceIdentifier", sourceIdentifier)
    def getSourceType
        : ZIO[Any, AwsError, zio.aws.elasticache.model.SourceType] =
      AwsError.unwrapOptionField("sourceType", sourceType)
    def getMessage: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("message", message)
    def getDate: ZIO[Any, AwsError, TStamp] =
      AwsError.unwrapOptionField("date", date)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.elasticache.model.Event
  ) extends zio.aws.elasticache.model.Event.ReadOnly {
    override val sourceIdentifier: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.sourceIdentifier())
      .map(value => value: String)
    override val sourceType: Optional[zio.aws.elasticache.model.SourceType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.sourceType())
        .map(value => zio.aws.elasticache.model.SourceType.wrap(value))
    override val message: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.message())
      .map(value => value: String)
    override val date: Optional[TStamp] = zio.aws.core.internal
      .optionalFromNullable(impl.date())
      .map(value => zio.aws.elasticache.model.primitives.TStamp(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.elasticache.model.Event
  ): zio.aws.elasticache.model.Event.ReadOnly = new Wrapper(impl)
}
