package zio.aws.elasticache.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.elasticache.model.primitives.TStamp
import scala.jdk.CollectionConverters._
final case class CacheNode(
    cacheNodeId: Optional[String] = Optional.Absent,
    cacheNodeStatus: Optional[String] = Optional.Absent,
    cacheNodeCreateTime: Optional[TStamp] = Optional.Absent,
    endpoint: Optional[zio.aws.elasticache.model.Endpoint] = Optional.Absent,
    parameterGroupStatus: Optional[String] = Optional.Absent,
    sourceCacheNodeId: Optional[String] = Optional.Absent,
    customerAvailabilityZone: Optional[String] = Optional.Absent,
    customerOutpostArn: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.elasticache.model.CacheNode = {
    import CacheNode.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.elasticache.model.CacheNode
      .builder()
      .optionallyWith(cacheNodeId.map(value => value: java.lang.String))(
        _.cacheNodeId
      )
      .optionallyWith(cacheNodeStatus.map(value => value: java.lang.String))(
        _.cacheNodeStatus
      )
      .optionallyWith(
        cacheNodeCreateTime.map(value => TStamp.unwrap(value): Instant)
      )(_.cacheNodeCreateTime)
      .optionallyWith(endpoint.map(value => value.buildAwsValue()))(_.endpoint)
      .optionallyWith(
        parameterGroupStatus.map(value => value: java.lang.String)
      )(_.parameterGroupStatus)
      .optionallyWith(sourceCacheNodeId.map(value => value: java.lang.String))(
        _.sourceCacheNodeId
      )
      .optionallyWith(
        customerAvailabilityZone.map(value => value: java.lang.String)
      )(_.customerAvailabilityZone)
      .optionallyWith(customerOutpostArn.map(value => value: java.lang.String))(
        _.customerOutpostArn
      )
      .build()
  }
  def asReadOnly: zio.aws.elasticache.model.CacheNode.ReadOnly =
    zio.aws.elasticache.model.CacheNode.wrap(buildAwsValue())
}
object CacheNode {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.elasticache.model.CacheNode
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.elasticache.model.CacheNode =
      zio.aws.elasticache.model.CacheNode(
        cacheNodeId.map(value => value),
        cacheNodeStatus.map(value => value),
        cacheNodeCreateTime.map(value => value),
        endpoint.map(value => value.asEditable),
        parameterGroupStatus.map(value => value),
        sourceCacheNodeId.map(value => value),
        customerAvailabilityZone.map(value => value),
        customerOutpostArn.map(value => value)
      )
    def cacheNodeId: Optional[String]
    def cacheNodeStatus: Optional[String]
    def cacheNodeCreateTime: Optional[TStamp]
    def endpoint: Optional[zio.aws.elasticache.model.Endpoint.ReadOnly]
    def parameterGroupStatus: Optional[String]
    def sourceCacheNodeId: Optional[String]
    def customerAvailabilityZone: Optional[String]
    def customerOutpostArn: Optional[String]
    def getCacheNodeId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("cacheNodeId", cacheNodeId)
    def getCacheNodeStatus: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("cacheNodeStatus", cacheNodeStatus)
    def getCacheNodeCreateTime: ZIO[Any, AwsError, TStamp] =
      AwsError.unwrapOptionField("cacheNodeCreateTime", cacheNodeCreateTime)
    def getEndpoint
        : ZIO[Any, AwsError, zio.aws.elasticache.model.Endpoint.ReadOnly] =
      AwsError.unwrapOptionField("endpoint", endpoint)
    def getParameterGroupStatus: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("parameterGroupStatus", parameterGroupStatus)
    def getSourceCacheNodeId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("sourceCacheNodeId", sourceCacheNodeId)
    def getCustomerAvailabilityZone: ZIO[Any, AwsError, String] = AwsError
      .unwrapOptionField("customerAvailabilityZone", customerAvailabilityZone)
    def getCustomerOutpostArn: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("customerOutpostArn", customerOutpostArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.elasticache.model.CacheNode
  ) extends zio.aws.elasticache.model.CacheNode.ReadOnly {
    override val cacheNodeId: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.cacheNodeId())
      .map(value => value: String)
    override val cacheNodeStatus: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.cacheNodeStatus())
      .map(value => value: String)
    override val cacheNodeCreateTime: Optional[TStamp] = zio.aws.core.internal
      .optionalFromNullable(impl.cacheNodeCreateTime())
      .map(value => zio.aws.elasticache.model.primitives.TStamp(value))
    override val endpoint
        : Optional[zio.aws.elasticache.model.Endpoint.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.endpoint())
        .map(value => zio.aws.elasticache.model.Endpoint.wrap(value))
    override val parameterGroupStatus: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.parameterGroupStatus())
      .map(value => value: String)
    override val sourceCacheNodeId: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.sourceCacheNodeId())
      .map(value => value: String)
    override val customerAvailabilityZone: Optional[String] =
      zio.aws.core.internal
        .optionalFromNullable(impl.customerAvailabilityZone())
        .map(value => value: String)
    override val customerOutpostArn: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.customerOutpostArn())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.elasticache.model.CacheNode
  ): zio.aws.elasticache.model.CacheNode.ReadOnly = new Wrapper(impl)
}
