package zio.aws.elasticache.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.elasticache.model.primitives.{BooleanOptional, IntegerOptional}
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class ModifyCacheClusterRequest(
    cacheClusterId: String,
    numCacheNodes: Optional[IntegerOptional] = Optional.Absent,
    cacheNodeIdsToRemove: Optional[Iterable[String]] = Optional.Absent,
    azMode: Optional[zio.aws.elasticache.model.AZMode] = Optional.Absent,
    newAvailabilityZones: Optional[Iterable[String]] = Optional.Absent,
    cacheSecurityGroupNames: Optional[Iterable[String]] = Optional.Absent,
    securityGroupIds: Optional[Iterable[String]] = Optional.Absent,
    preferredMaintenanceWindow: Optional[String] = Optional.Absent,
    notificationTopicArn: Optional[String] = Optional.Absent,
    cacheParameterGroupName: Optional[String] = Optional.Absent,
    notificationTopicStatus: Optional[String] = Optional.Absent,
    applyImmediately: Optional[Boolean] = Optional.Absent,
    engineVersion: Optional[String] = Optional.Absent,
    autoMinorVersionUpgrade: Optional[BooleanOptional] = Optional.Absent,
    snapshotRetentionLimit: Optional[IntegerOptional] = Optional.Absent,
    snapshotWindow: Optional[String] = Optional.Absent,
    cacheNodeType: Optional[String] = Optional.Absent,
    authToken: Optional[String] = Optional.Absent,
    authTokenUpdateStrategy: Optional[
      zio.aws.elasticache.model.AuthTokenUpdateStrategyType
    ] = Optional.Absent,
    logDeliveryConfigurations: Optional[
      Iterable[zio.aws.elasticache.model.LogDeliveryConfigurationRequest]
    ] = Optional.Absent,
    ipDiscovery: Optional[zio.aws.elasticache.model.IpDiscovery] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.elasticache.model.ModifyCacheClusterRequest = {
    import ModifyCacheClusterRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.elasticache.model.ModifyCacheClusterRequest
      .builder()
      .cacheClusterId(cacheClusterId: java.lang.String)
      .optionallyWith(numCacheNodes.map(value => value: Integer))(
        _.numCacheNodes
      )
      .optionallyWith(
        cacheNodeIdsToRemove.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.cacheNodeIdsToRemove)
      .optionallyWith(azMode.map(value => value.unwrap))(_.azMode)
      .optionallyWith(
        newAvailabilityZones.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.newAvailabilityZones)
      .optionallyWith(
        cacheSecurityGroupNames.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.cacheSecurityGroupNames)
      .optionallyWith(
        securityGroupIds.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.securityGroupIds)
      .optionallyWith(
        preferredMaintenanceWindow.map(value => value: java.lang.String)
      )(_.preferredMaintenanceWindow)
      .optionallyWith(
        notificationTopicArn.map(value => value: java.lang.String)
      )(_.notificationTopicArn)
      .optionallyWith(
        cacheParameterGroupName.map(value => value: java.lang.String)
      )(_.cacheParameterGroupName)
      .optionallyWith(
        notificationTopicStatus.map(value => value: java.lang.String)
      )(_.notificationTopicStatus)
      .optionallyWith(applyImmediately.map(value => value: java.lang.Boolean))(
        _.applyImmediately
      )
      .optionallyWith(engineVersion.map(value => value: java.lang.String))(
        _.engineVersion
      )
      .optionallyWith(
        autoMinorVersionUpgrade.map(value => value: java.lang.Boolean)
      )(_.autoMinorVersionUpgrade)
      .optionallyWith(snapshotRetentionLimit.map(value => value: Integer))(
        _.snapshotRetentionLimit
      )
      .optionallyWith(snapshotWindow.map(value => value: java.lang.String))(
        _.snapshotWindow
      )
      .optionallyWith(cacheNodeType.map(value => value: java.lang.String))(
        _.cacheNodeType
      )
      .optionallyWith(authToken.map(value => value: java.lang.String))(
        _.authToken
      )
      .optionallyWith(authTokenUpdateStrategy.map(value => value.unwrap))(
        _.authTokenUpdateStrategy
      )
      .optionallyWith(
        logDeliveryConfigurations.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.logDeliveryConfigurations)
      .optionallyWith(ipDiscovery.map(value => value.unwrap))(_.ipDiscovery)
      .build()
  }
  def asReadOnly: zio.aws.elasticache.model.ModifyCacheClusterRequest.ReadOnly =
    zio.aws.elasticache.model.ModifyCacheClusterRequest.wrap(buildAwsValue())
}
object ModifyCacheClusterRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.elasticache.model.ModifyCacheClusterRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.elasticache.model.ModifyCacheClusterRequest =
      zio.aws.elasticache.model.ModifyCacheClusterRequest(
        cacheClusterId,
        numCacheNodes.map(value => value),
        cacheNodeIdsToRemove.map(value => value),
        azMode.map(value => value),
        newAvailabilityZones.map(value => value),
        cacheSecurityGroupNames.map(value => value),
        securityGroupIds.map(value => value),
        preferredMaintenanceWindow.map(value => value),
        notificationTopicArn.map(value => value),
        cacheParameterGroupName.map(value => value),
        notificationTopicStatus.map(value => value),
        applyImmediately.map(value => value),
        engineVersion.map(value => value),
        autoMinorVersionUpgrade.map(value => value),
        snapshotRetentionLimit.map(value => value),
        snapshotWindow.map(value => value),
        cacheNodeType.map(value => value),
        authToken.map(value => value),
        authTokenUpdateStrategy.map(value => value),
        logDeliveryConfigurations.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        ipDiscovery.map(value => value)
      )
    def cacheClusterId: String
    def numCacheNodes: Optional[IntegerOptional]
    def cacheNodeIdsToRemove: Optional[List[String]]
    def azMode: Optional[zio.aws.elasticache.model.AZMode]
    def newAvailabilityZones: Optional[List[String]]
    def cacheSecurityGroupNames: Optional[List[String]]
    def securityGroupIds: Optional[List[String]]
    def preferredMaintenanceWindow: Optional[String]
    def notificationTopicArn: Optional[String]
    def cacheParameterGroupName: Optional[String]
    def notificationTopicStatus: Optional[String]
    def applyImmediately: Optional[Boolean]
    def engineVersion: Optional[String]
    def autoMinorVersionUpgrade: Optional[BooleanOptional]
    def snapshotRetentionLimit: Optional[IntegerOptional]
    def snapshotWindow: Optional[String]
    def cacheNodeType: Optional[String]
    def authToken: Optional[String]
    def authTokenUpdateStrategy
        : Optional[zio.aws.elasticache.model.AuthTokenUpdateStrategyType]
    def logDeliveryConfigurations: Optional[
      List[zio.aws.elasticache.model.LogDeliveryConfigurationRequest.ReadOnly]
    ]
    def ipDiscovery: Optional[zio.aws.elasticache.model.IpDiscovery]
    def getCacheClusterId: ZIO[Any, Nothing, String] =
      ZIO.succeed(cacheClusterId)
    def getNumCacheNodes: ZIO[Any, AwsError, IntegerOptional] =
      AwsError.unwrapOptionField("numCacheNodes", numCacheNodes)
    def getCacheNodeIdsToRemove: ZIO[Any, AwsError, List[String]] =
      AwsError.unwrapOptionField("cacheNodeIdsToRemove", cacheNodeIdsToRemove)
    def getAzMode: ZIO[Any, AwsError, zio.aws.elasticache.model.AZMode] =
      AwsError.unwrapOptionField("azMode", azMode)
    def getNewAvailabilityZones: ZIO[Any, AwsError, List[String]] =
      AwsError.unwrapOptionField("newAvailabilityZones", newAvailabilityZones)
    def getCacheSecurityGroupNames: ZIO[Any, AwsError, List[String]] = AwsError
      .unwrapOptionField("cacheSecurityGroupNames", cacheSecurityGroupNames)
    def getSecurityGroupIds: ZIO[Any, AwsError, List[String]] =
      AwsError.unwrapOptionField("securityGroupIds", securityGroupIds)
    def getPreferredMaintenanceWindow: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField(
        "preferredMaintenanceWindow",
        preferredMaintenanceWindow
      )
    def getNotificationTopicArn: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("notificationTopicArn", notificationTopicArn)
    def getCacheParameterGroupName: ZIO[Any, AwsError, String] = AwsError
      .unwrapOptionField("cacheParameterGroupName", cacheParameterGroupName)
    def getNotificationTopicStatus: ZIO[Any, AwsError, String] = AwsError
      .unwrapOptionField("notificationTopicStatus", notificationTopicStatus)
    def getApplyImmediately: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("applyImmediately", applyImmediately)
    def getEngineVersion: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("engineVersion", engineVersion)
    def getAutoMinorVersionUpgrade: ZIO[Any, AwsError, BooleanOptional] =
      AwsError.unwrapOptionField(
        "autoMinorVersionUpgrade",
        autoMinorVersionUpgrade
      )
    def getSnapshotRetentionLimit: ZIO[Any, AwsError, IntegerOptional] =
      AwsError.unwrapOptionField(
        "snapshotRetentionLimit",
        snapshotRetentionLimit
      )
    def getSnapshotWindow: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("snapshotWindow", snapshotWindow)
    def getCacheNodeType: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("cacheNodeType", cacheNodeType)
    def getAuthToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("authToken", authToken)
    def getAuthTokenUpdateStrategy: ZIO[
      Any,
      AwsError,
      zio.aws.elasticache.model.AuthTokenUpdateStrategyType
    ] = AwsError.unwrapOptionField(
      "authTokenUpdateStrategy",
      authTokenUpdateStrategy
    )
    def getLogDeliveryConfigurations: ZIO[Any, AwsError, List[
      zio.aws.elasticache.model.LogDeliveryConfigurationRequest.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "logDeliveryConfigurations",
      logDeliveryConfigurations
    )
    def getIpDiscovery
        : ZIO[Any, AwsError, zio.aws.elasticache.model.IpDiscovery] =
      AwsError.unwrapOptionField("ipDiscovery", ipDiscovery)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.elasticache.model.ModifyCacheClusterRequest
  ) extends zio.aws.elasticache.model.ModifyCacheClusterRequest.ReadOnly {
    override val cacheClusterId: String = impl.cacheClusterId(): String
    override val numCacheNodes: Optional[IntegerOptional] =
      zio.aws.core.internal
        .optionalFromNullable(impl.numCacheNodes())
        .map(value => value: IntegerOptional)
    override val cacheNodeIdsToRemove: Optional[List[String]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.cacheNodeIdsToRemove())
        .map(value =>
          value.asScala.map { item =>
            item: String
          }.toList
        )
    override val azMode: Optional[zio.aws.elasticache.model.AZMode] =
      zio.aws.core.internal
        .optionalFromNullable(impl.azMode())
        .map(value => zio.aws.elasticache.model.AZMode.wrap(value))
    override val newAvailabilityZones: Optional[List[String]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.newAvailabilityZones())
        .map(value =>
          value.asScala.map { item =>
            item: String
          }.toList
        )
    override val cacheSecurityGroupNames: Optional[List[String]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.cacheSecurityGroupNames())
        .map(value =>
          value.asScala.map { item =>
            item: String
          }.toList
        )
    override val securityGroupIds: Optional[List[String]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.securityGroupIds())
        .map(value =>
          value.asScala.map { item =>
            item: String
          }.toList
        )
    override val preferredMaintenanceWindow: Optional[String] =
      zio.aws.core.internal
        .optionalFromNullable(impl.preferredMaintenanceWindow())
        .map(value => value: String)
    override val notificationTopicArn: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.notificationTopicArn())
      .map(value => value: String)
    override val cacheParameterGroupName: Optional[String] =
      zio.aws.core.internal
        .optionalFromNullable(impl.cacheParameterGroupName())
        .map(value => value: String)
    override val notificationTopicStatus: Optional[String] =
      zio.aws.core.internal
        .optionalFromNullable(impl.notificationTopicStatus())
        .map(value => value: String)
    override val applyImmediately: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.applyImmediately())
      .map(value => value: Boolean)
    override val engineVersion: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.engineVersion())
      .map(value => value: String)
    override val autoMinorVersionUpgrade: Optional[BooleanOptional] =
      zio.aws.core.internal
        .optionalFromNullable(impl.autoMinorVersionUpgrade())
        .map(value => value: BooleanOptional)
    override val snapshotRetentionLimit: Optional[IntegerOptional] =
      zio.aws.core.internal
        .optionalFromNullable(impl.snapshotRetentionLimit())
        .map(value => value: IntegerOptional)
    override val snapshotWindow: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.snapshotWindow())
      .map(value => value: String)
    override val cacheNodeType: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.cacheNodeType())
      .map(value => value: String)
    override val authToken: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.authToken())
      .map(value => value: String)
    override val authTokenUpdateStrategy
        : Optional[zio.aws.elasticache.model.AuthTokenUpdateStrategyType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.authTokenUpdateStrategy())
        .map(value =>
          zio.aws.elasticache.model.AuthTokenUpdateStrategyType.wrap(value)
        )
    override val logDeliveryConfigurations: Optional[
      List[zio.aws.elasticache.model.LogDeliveryConfigurationRequest.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.logDeliveryConfigurations())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.elasticache.model.LogDeliveryConfigurationRequest.wrap(item)
        }.toList
      )
    override val ipDiscovery: Optional[zio.aws.elasticache.model.IpDiscovery] =
      zio.aws.core.internal
        .optionalFromNullable(impl.ipDiscovery())
        .map(value => zio.aws.elasticache.model.IpDiscovery.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.elasticache.model.ModifyCacheClusterRequest
  ): zio.aws.elasticache.model.ModifyCacheClusterRequest.ReadOnly = new Wrapper(
    impl
  )
}
