package zio.aws.elasticache.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class EngineDefaults(
    cacheParameterGroupFamily: Optional[String] = Optional.Absent,
    marker: Optional[String] = Optional.Absent,
    parameters: Optional[Iterable[zio.aws.elasticache.model.Parameter]] =
      Optional.Absent,
    cacheNodeTypeSpecificParameters: Optional[
      Iterable[zio.aws.elasticache.model.CacheNodeTypeSpecificParameter]
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.elasticache.model.EngineDefaults = {
    import EngineDefaults.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.elasticache.model.EngineDefaults
      .builder()
      .optionallyWith(
        cacheParameterGroupFamily.map(value => value: java.lang.String)
      )(_.cacheParameterGroupFamily)
      .optionallyWith(marker.map(value => value: java.lang.String))(_.marker)
      .optionallyWith(
        parameters.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.parameters)
      .optionallyWith(
        cacheNodeTypeSpecificParameters.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.cacheNodeTypeSpecificParameters)
      .build()
  }
  def asReadOnly: zio.aws.elasticache.model.EngineDefaults.ReadOnly =
    zio.aws.elasticache.model.EngineDefaults.wrap(buildAwsValue())
}
object EngineDefaults {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.elasticache.model.EngineDefaults
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.elasticache.model.EngineDefaults =
      zio.aws.elasticache.model.EngineDefaults(
        cacheParameterGroupFamily.map(value => value),
        marker.map(value => value),
        parameters.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        cacheNodeTypeSpecificParameters.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def cacheParameterGroupFamily: Optional[String]
    def marker: Optional[String]
    def parameters: Optional[List[zio.aws.elasticache.model.Parameter.ReadOnly]]
    def cacheNodeTypeSpecificParameters: Optional[
      List[zio.aws.elasticache.model.CacheNodeTypeSpecificParameter.ReadOnly]
    ]
    def getCacheParameterGroupFamily: ZIO[Any, AwsError, String] = AwsError
      .unwrapOptionField("cacheParameterGroupFamily", cacheParameterGroupFamily)
    def getMarker: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("marker", marker)
    def getParameters: ZIO[Any, AwsError, List[
      zio.aws.elasticache.model.Parameter.ReadOnly
    ]] = AwsError.unwrapOptionField("parameters", parameters)
    def getCacheNodeTypeSpecificParameters: ZIO[Any, AwsError, List[
      zio.aws.elasticache.model.CacheNodeTypeSpecificParameter.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "cacheNodeTypeSpecificParameters",
      cacheNodeTypeSpecificParameters
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.elasticache.model.EngineDefaults
  ) extends zio.aws.elasticache.model.EngineDefaults.ReadOnly {
    override val cacheParameterGroupFamily: Optional[String] =
      zio.aws.core.internal
        .optionalFromNullable(impl.cacheParameterGroupFamily())
        .map(value => value: String)
    override val marker: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.marker())
      .map(value => value: String)
    override val parameters
        : Optional[List[zio.aws.elasticache.model.Parameter.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.parameters())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.elasticache.model.Parameter.wrap(item)
          }.toList
        )
    override val cacheNodeTypeSpecificParameters: Optional[
      List[zio.aws.elasticache.model.CacheNodeTypeSpecificParameter.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.cacheNodeTypeSpecificParameters())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.elasticache.model.CacheNodeTypeSpecificParameter.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.elasticache.model.EngineDefaults
  ): zio.aws.elasticache.model.EngineDefaults.ReadOnly = new Wrapper(impl)
}
