package zio.aws.elasticache.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.elasticache.model.primitives.IntegerOptional
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class DescribeEngineDefaultParametersRequest(
    cacheParameterGroupFamily: String,
    maxRecords: Optional[IntegerOptional] = Optional.Absent,
    marker: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.elasticache.model.DescribeEngineDefaultParametersRequest = {
    import DescribeEngineDefaultParametersRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.elasticache.model.DescribeEngineDefaultParametersRequest
      .builder()
      .cacheParameterGroupFamily(cacheParameterGroupFamily: java.lang.String)
      .optionallyWith(maxRecords.map(value => value: Integer))(_.maxRecords)
      .optionallyWith(marker.map(value => value: java.lang.String))(_.marker)
      .build()
  }
  def asReadOnly
      : zio.aws.elasticache.model.DescribeEngineDefaultParametersRequest.ReadOnly =
    zio.aws.elasticache.model.DescribeEngineDefaultParametersRequest
      .wrap(buildAwsValue())
}
object DescribeEngineDefaultParametersRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.elasticache.model.DescribeEngineDefaultParametersRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.elasticache.model.DescribeEngineDefaultParametersRequest =
      zio.aws.elasticache.model.DescribeEngineDefaultParametersRequest(
        cacheParameterGroupFamily,
        maxRecords.map(value => value),
        marker.map(value => value)
      )
    def cacheParameterGroupFamily: String
    def maxRecords: Optional[IntegerOptional]
    def marker: Optional[String]
    def getCacheParameterGroupFamily: ZIO[Any, Nothing, String] =
      ZIO.succeed(cacheParameterGroupFamily)
    def getMaxRecords: ZIO[Any, AwsError, IntegerOptional] =
      AwsError.unwrapOptionField("maxRecords", maxRecords)
    def getMarker: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("marker", marker)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.elasticache.model.DescribeEngineDefaultParametersRequest
  ) extends zio.aws.elasticache.model.DescribeEngineDefaultParametersRequest.ReadOnly {
    override val cacheParameterGroupFamily: String =
      impl.cacheParameterGroupFamily(): String
    override val maxRecords: Optional[IntegerOptional] = zio.aws.core.internal
      .optionalFromNullable(impl.maxRecords())
      .map(value => value: IntegerOptional)
    override val marker: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.marker())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.elasticache.model.DescribeEngineDefaultParametersRequest
  ): zio.aws.elasticache.model.DescribeEngineDefaultParametersRequest.ReadOnly =
    new Wrapper(impl)
}
