package zio.aws.elasticache.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.elasticache.model.primitives.{IntegerOptional, BooleanOptional}
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class DescribeUpdateActionsRequest(
    serviceUpdateName: Optional[String] = Optional.Absent,
    replicationGroupIds: Optional[Iterable[String]] = Optional.Absent,
    cacheClusterIds: Optional[Iterable[String]] = Optional.Absent,
    engine: Optional[String] = Optional.Absent,
    serviceUpdateStatus: Optional[
      Iterable[zio.aws.elasticache.model.ServiceUpdateStatus]
    ] = Optional.Absent,
    serviceUpdateTimeRange: Optional[
      zio.aws.elasticache.model.TimeRangeFilter
    ] = Optional.Absent,
    updateActionStatus: Optional[
      Iterable[zio.aws.elasticache.model.UpdateActionStatus]
    ] = Optional.Absent,
    showNodeLevelUpdateStatus: Optional[BooleanOptional] = Optional.Absent,
    maxRecords: Optional[IntegerOptional] = Optional.Absent,
    marker: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.elasticache.model.DescribeUpdateActionsRequest = {
    import DescribeUpdateActionsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.elasticache.model.DescribeUpdateActionsRequest
      .builder()
      .optionallyWith(serviceUpdateName.map(value => value: java.lang.String))(
        _.serviceUpdateName
      )
      .optionallyWith(
        replicationGroupIds.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.replicationGroupIds)
      .optionallyWith(
        cacheClusterIds.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.cacheClusterIds)
      .optionallyWith(engine.map(value => value: java.lang.String))(_.engine)
      .optionallyWith(
        serviceUpdateStatus.map(value =>
          value.map { item =>
            item.unwrap.toString
          }.asJavaCollection
        )
      )(_.serviceUpdateStatusWithStrings)
      .optionallyWith(
        serviceUpdateTimeRange.map(value => value.buildAwsValue())
      )(_.serviceUpdateTimeRange)
      .optionallyWith(
        updateActionStatus.map(value =>
          value.map { item =>
            item.unwrap.toString
          }.asJavaCollection
        )
      )(_.updateActionStatusWithStrings)
      .optionallyWith(
        showNodeLevelUpdateStatus.map(value => value: java.lang.Boolean)
      )(_.showNodeLevelUpdateStatus)
      .optionallyWith(maxRecords.map(value => value: Integer))(_.maxRecords)
      .optionallyWith(marker.map(value => value: java.lang.String))(_.marker)
      .build()
  }
  def asReadOnly
      : zio.aws.elasticache.model.DescribeUpdateActionsRequest.ReadOnly =
    zio.aws.elasticache.model.DescribeUpdateActionsRequest.wrap(buildAwsValue())
}
object DescribeUpdateActionsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.elasticache.model.DescribeUpdateActionsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.elasticache.model.DescribeUpdateActionsRequest =
      zio.aws.elasticache.model.DescribeUpdateActionsRequest(
        serviceUpdateName.map(value => value),
        replicationGroupIds.map(value => value),
        cacheClusterIds.map(value => value),
        engine.map(value => value),
        serviceUpdateStatus.map(value => value),
        serviceUpdateTimeRange.map(value => value.asEditable),
        updateActionStatus.map(value => value),
        showNodeLevelUpdateStatus.map(value => value),
        maxRecords.map(value => value),
        marker.map(value => value)
      )
    def serviceUpdateName: Optional[String]
    def replicationGroupIds: Optional[List[String]]
    def cacheClusterIds: Optional[List[String]]
    def engine: Optional[String]
    def serviceUpdateStatus
        : Optional[List[zio.aws.elasticache.model.ServiceUpdateStatus]]
    def serviceUpdateTimeRange
        : Optional[zio.aws.elasticache.model.TimeRangeFilter.ReadOnly]
    def updateActionStatus
        : Optional[List[zio.aws.elasticache.model.UpdateActionStatus]]
    def showNodeLevelUpdateStatus: Optional[BooleanOptional]
    def maxRecords: Optional[IntegerOptional]
    def marker: Optional[String]
    def getServiceUpdateName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("serviceUpdateName", serviceUpdateName)
    def getReplicationGroupIds: ZIO[Any, AwsError, List[String]] =
      AwsError.unwrapOptionField("replicationGroupIds", replicationGroupIds)
    def getCacheClusterIds: ZIO[Any, AwsError, List[String]] =
      AwsError.unwrapOptionField("cacheClusterIds", cacheClusterIds)
    def getEngine: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("engine", engine)
    def getServiceUpdateStatus: ZIO[Any, AwsError, List[
      zio.aws.elasticache.model.ServiceUpdateStatus
    ]] = AwsError.unwrapOptionField("serviceUpdateStatus", serviceUpdateStatus)
    def getServiceUpdateTimeRange: ZIO[
      Any,
      AwsError,
      zio.aws.elasticache.model.TimeRangeFilter.ReadOnly
    ] = AwsError.unwrapOptionField(
      "serviceUpdateTimeRange",
      serviceUpdateTimeRange
    )
    def getUpdateActionStatus: ZIO[Any, AwsError, List[
      zio.aws.elasticache.model.UpdateActionStatus
    ]] = AwsError.unwrapOptionField("updateActionStatus", updateActionStatus)
    def getShowNodeLevelUpdateStatus: ZIO[Any, AwsError, BooleanOptional] =
      AwsError.unwrapOptionField(
        "showNodeLevelUpdateStatus",
        showNodeLevelUpdateStatus
      )
    def getMaxRecords: ZIO[Any, AwsError, IntegerOptional] =
      AwsError.unwrapOptionField("maxRecords", maxRecords)
    def getMarker: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("marker", marker)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.elasticache.model.DescribeUpdateActionsRequest
  ) extends zio.aws.elasticache.model.DescribeUpdateActionsRequest.ReadOnly {
    override val serviceUpdateName: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.serviceUpdateName())
      .map(value => value: String)
    override val replicationGroupIds: Optional[List[String]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.replicationGroupIds())
        .map(value =>
          value.asScala.map { item =>
            item: String
          }.toList
        )
    override val cacheClusterIds: Optional[List[String]] = zio.aws.core.internal
      .optionalFromNullable(impl.cacheClusterIds())
      .map(value =>
        value.asScala.map { item =>
          item: String
        }.toList
      )
    override val engine: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.engine())
      .map(value => value: String)
    override val serviceUpdateStatus
        : Optional[List[zio.aws.elasticache.model.ServiceUpdateStatus]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.serviceUpdateStatus())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.elasticache.model.ServiceUpdateStatus.wrap(item)
          }.toList
        )
    override val serviceUpdateTimeRange
        : Optional[zio.aws.elasticache.model.TimeRangeFilter.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.serviceUpdateTimeRange())
        .map(value => zio.aws.elasticache.model.TimeRangeFilter.wrap(value))
    override val updateActionStatus
        : Optional[List[zio.aws.elasticache.model.UpdateActionStatus]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.updateActionStatus())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.elasticache.model.UpdateActionStatus.wrap(item)
          }.toList
        )
    override val showNodeLevelUpdateStatus: Optional[BooleanOptional] =
      zio.aws.core.internal
        .optionalFromNullable(impl.showNodeLevelUpdateStatus())
        .map(value => value: BooleanOptional)
    override val maxRecords: Optional[IntegerOptional] = zio.aws.core.internal
      .optionalFromNullable(impl.maxRecords())
      .map(value => value: IntegerOptional)
    override val marker: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.marker())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.elasticache.model.DescribeUpdateActionsRequest
  ): zio.aws.elasticache.model.DescribeUpdateActionsRequest.ReadOnly =
    new Wrapper(impl)
}
