package zio.aws.elasticache.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class DescribeReservedCacheNodesResponse(
    marker: Optional[String] = Optional.Absent,
    reservedCacheNodes: Optional[
      Iterable[zio.aws.elasticache.model.ReservedCacheNode]
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.elasticache.model.DescribeReservedCacheNodesResponse = {
    import DescribeReservedCacheNodesResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.elasticache.model.DescribeReservedCacheNodesResponse
      .builder()
      .optionallyWith(marker.map(value => value: java.lang.String))(_.marker)
      .optionallyWith(
        reservedCacheNodes.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.reservedCacheNodes)
      .build()
  }
  def asReadOnly
      : zio.aws.elasticache.model.DescribeReservedCacheNodesResponse.ReadOnly =
    zio.aws.elasticache.model.DescribeReservedCacheNodesResponse
      .wrap(buildAwsValue())
}
object DescribeReservedCacheNodesResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.elasticache.model.DescribeReservedCacheNodesResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.elasticache.model.DescribeReservedCacheNodesResponse =
      zio.aws.elasticache.model.DescribeReservedCacheNodesResponse(
        marker.map(value => value),
        reservedCacheNodes.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def marker: Optional[String]
    def reservedCacheNodes
        : Optional[List[zio.aws.elasticache.model.ReservedCacheNode.ReadOnly]]
    def getMarker: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("marker", marker)
    def getReservedCacheNodes: ZIO[Any, AwsError, List[
      zio.aws.elasticache.model.ReservedCacheNode.ReadOnly
    ]] = AwsError.unwrapOptionField("reservedCacheNodes", reservedCacheNodes)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.elasticache.model.DescribeReservedCacheNodesResponse
  ) extends zio.aws.elasticache.model.DescribeReservedCacheNodesResponse.ReadOnly {
    override val marker: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.marker())
      .map(value => value: String)
    override val reservedCacheNodes
        : Optional[List[zio.aws.elasticache.model.ReservedCacheNode.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.reservedCacheNodes())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.elasticache.model.ReservedCacheNode.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.elasticache.model.DescribeReservedCacheNodesResponse
  ): zio.aws.elasticache.model.DescribeReservedCacheNodesResponse.ReadOnly =
    new Wrapper(impl)
}
