package zio.aws.elasticache.model
import zio.aws.elasticache.model.primitives.AllowedNodeGroupId
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class TestFailoverRequest(
    replicationGroupId: String,
    nodeGroupId: AllowedNodeGroupId
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.elasticache.model.TestFailoverRequest = {
    import TestFailoverRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.elasticache.model.TestFailoverRequest
      .builder()
      .replicationGroupId(replicationGroupId: java.lang.String)
      .nodeGroupId(AllowedNodeGroupId.unwrap(nodeGroupId): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.elasticache.model.TestFailoverRequest.ReadOnly =
    zio.aws.elasticache.model.TestFailoverRequest.wrap(buildAwsValue())
}
object TestFailoverRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.elasticache.model.TestFailoverRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.elasticache.model.TestFailoverRequest =
      zio.aws.elasticache.model
        .TestFailoverRequest(replicationGroupId, nodeGroupId)
    def replicationGroupId: String
    def nodeGroupId: AllowedNodeGroupId
    def getReplicationGroupId: ZIO[Any, Nothing, String] =
      ZIO.succeed(replicationGroupId)
    def getNodeGroupId: ZIO[Any, Nothing, AllowedNodeGroupId] =
      ZIO.succeed(nodeGroupId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.elasticache.model.TestFailoverRequest
  ) extends zio.aws.elasticache.model.TestFailoverRequest.ReadOnly {
    override val replicationGroupId: String = impl.replicationGroupId(): String
    override val nodeGroupId: AllowedNodeGroupId =
      zio.aws.elasticache.model.primitives
        .AllowedNodeGroupId(impl.nodeGroupId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.elasticache.model.TestFailoverRequest
  ): zio.aws.elasticache.model.TestFailoverRequest.ReadOnly = new Wrapper(impl)
}
