package zio.aws.elasticache.model
import scala.jdk.CollectionConverters._
sealed trait ServiceUpdateSeverity {
  def unwrap
      : software.amazon.awssdk.services.elasticache.model.ServiceUpdateSeverity
}
object ServiceUpdateSeverity {
  def wrap(
      value: software.amazon.awssdk.services.elasticache.model.ServiceUpdateSeverity
  ): zio.aws.elasticache.model.ServiceUpdateSeverity = value match {
    case software.amazon.awssdk.services.elasticache.model.ServiceUpdateSeverity.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.elasticache.model.ServiceUpdateSeverity.CRITICAL =>
      val r = critical
      r
    case software.amazon.awssdk.services.elasticache.model.ServiceUpdateSeverity.IMPORTANT =>
      val r = important
      r
    case software.amazon.awssdk.services.elasticache.model.ServiceUpdateSeverity.MEDIUM =>
      val r = medium
      r
    case software.amazon.awssdk.services.elasticache.model.ServiceUpdateSeverity.LOW =>
      val r = low
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.elasticache.model.ServiceUpdateSeverity {
    override def unwrap
        : software.amazon.awssdk.services.elasticache.model.ServiceUpdateSeverity =
      software.amazon.awssdk.services.elasticache.model.ServiceUpdateSeverity.UNKNOWN_TO_SDK_VERSION
  }
  case object critical extends zio.aws.elasticache.model.ServiceUpdateSeverity {
    override def unwrap
        : software.amazon.awssdk.services.elasticache.model.ServiceUpdateSeverity =
      software.amazon.awssdk.services.elasticache.model.ServiceUpdateSeverity.CRITICAL
  }
  case object important
      extends zio.aws.elasticache.model.ServiceUpdateSeverity {
    override def unwrap
        : software.amazon.awssdk.services.elasticache.model.ServiceUpdateSeverity =
      software.amazon.awssdk.services.elasticache.model.ServiceUpdateSeverity.IMPORTANT
  }
  case object medium extends zio.aws.elasticache.model.ServiceUpdateSeverity {
    override def unwrap
        : software.amazon.awssdk.services.elasticache.model.ServiceUpdateSeverity =
      software.amazon.awssdk.services.elasticache.model.ServiceUpdateSeverity.MEDIUM
  }
  case object low extends zio.aws.elasticache.model.ServiceUpdateSeverity {
    override def unwrap
        : software.amazon.awssdk.services.elasticache.model.ServiceUpdateSeverity =
      software.amazon.awssdk.services.elasticache.model.ServiceUpdateSeverity.LOW
  }
}
