package zio.aws.elasticache.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class RebootCacheClusterRequest(
    cacheClusterId: String,
    cacheNodeIdsToReboot: Iterable[String]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.elasticache.model.RebootCacheClusterRequest = {
    import RebootCacheClusterRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.elasticache.model.RebootCacheClusterRequest
      .builder()
      .cacheClusterId(cacheClusterId: java.lang.String)
      .cacheNodeIdsToReboot(cacheNodeIdsToReboot.map { item =>
        item: java.lang.String
      }.asJavaCollection)
      .build()
  }
  def asReadOnly: zio.aws.elasticache.model.RebootCacheClusterRequest.ReadOnly =
    zio.aws.elasticache.model.RebootCacheClusterRequest.wrap(buildAwsValue())
}
object RebootCacheClusterRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.elasticache.model.RebootCacheClusterRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.elasticache.model.RebootCacheClusterRequest =
      zio.aws.elasticache.model
        .RebootCacheClusterRequest(cacheClusterId, cacheNodeIdsToReboot)
    def cacheClusterId: String
    def cacheNodeIdsToReboot: List[String]
    def getCacheClusterId: ZIO[Any, Nothing, String] =
      ZIO.succeed(cacheClusterId)
    def getCacheNodeIdsToReboot: ZIO[Any, Nothing, List[String]] =
      ZIO.succeed(cacheNodeIdsToReboot)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.elasticache.model.RebootCacheClusterRequest
  ) extends zio.aws.elasticache.model.RebootCacheClusterRequest.ReadOnly {
    override val cacheClusterId: String = impl.cacheClusterId(): String
    override val cacheNodeIdsToReboot: List[String] = impl
      .cacheNodeIdsToReboot()
      .asScala
      .map { item =>
        item: String
      }
      .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.elasticache.model.RebootCacheClusterRequest
  ): zio.aws.elasticache.model.RebootCacheClusterRequest.ReadOnly = new Wrapper(
    impl
  )
}
