package zio.aws.elasticache.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.elasticache.model.primitives.IntegerOptional
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class DescribeServiceUpdatesRequest(
    serviceUpdateName: Optional[String] = Optional.Absent,
    serviceUpdateStatus: Optional[
      Iterable[zio.aws.elasticache.model.ServiceUpdateStatus]
    ] = Optional.Absent,
    maxRecords: Optional[IntegerOptional] = Optional.Absent,
    marker: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.elasticache.model.DescribeServiceUpdatesRequest = {
    import DescribeServiceUpdatesRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.elasticache.model.DescribeServiceUpdatesRequest
      .builder()
      .optionallyWith(serviceUpdateName.map(value => value: java.lang.String))(
        _.serviceUpdateName
      )
      .optionallyWith(
        serviceUpdateStatus.map(value =>
          value.map { item =>
            item.unwrap.toString
          }.asJavaCollection
        )
      )(_.serviceUpdateStatusWithStrings)
      .optionallyWith(maxRecords.map(value => value: Integer))(_.maxRecords)
      .optionallyWith(marker.map(value => value: java.lang.String))(_.marker)
      .build()
  }
  def asReadOnly
      : zio.aws.elasticache.model.DescribeServiceUpdatesRequest.ReadOnly =
    zio.aws.elasticache.model.DescribeServiceUpdatesRequest
      .wrap(buildAwsValue())
}
object DescribeServiceUpdatesRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.elasticache.model.DescribeServiceUpdatesRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.elasticache.model.DescribeServiceUpdatesRequest =
      zio.aws.elasticache.model.DescribeServiceUpdatesRequest(
        serviceUpdateName.map(value => value),
        serviceUpdateStatus.map(value => value),
        maxRecords.map(value => value),
        marker.map(value => value)
      )
    def serviceUpdateName: Optional[String]
    def serviceUpdateStatus
        : Optional[List[zio.aws.elasticache.model.ServiceUpdateStatus]]
    def maxRecords: Optional[IntegerOptional]
    def marker: Optional[String]
    def getServiceUpdateName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("serviceUpdateName", serviceUpdateName)
    def getServiceUpdateStatus: ZIO[Any, AwsError, List[
      zio.aws.elasticache.model.ServiceUpdateStatus
    ]] = AwsError.unwrapOptionField("serviceUpdateStatus", serviceUpdateStatus)
    def getMaxRecords: ZIO[Any, AwsError, IntegerOptional] =
      AwsError.unwrapOptionField("maxRecords", maxRecords)
    def getMarker: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("marker", marker)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.elasticache.model.DescribeServiceUpdatesRequest
  ) extends zio.aws.elasticache.model.DescribeServiceUpdatesRequest.ReadOnly {
    override val serviceUpdateName: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.serviceUpdateName())
      .map(value => value: String)
    override val serviceUpdateStatus
        : Optional[List[zio.aws.elasticache.model.ServiceUpdateStatus]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.serviceUpdateStatus())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.elasticache.model.ServiceUpdateStatus.wrap(item)
          }.toList
        )
    override val maxRecords: Optional[IntegerOptional] = zio.aws.core.internal
      .optionalFromNullable(impl.maxRecords())
      .map(value => value: IntegerOptional)
    override val marker: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.marker())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.elasticache.model.DescribeServiceUpdatesRequest
  ): zio.aws.elasticache.model.DescribeServiceUpdatesRequest.ReadOnly =
    new Wrapper(impl)
}
