package zio.aws.elasticache.model
import scala.jdk.CollectionConverters._
sealed trait SlaMet {
  def unwrap: software.amazon.awssdk.services.elasticache.model.SlaMet
}
object SlaMet {
  def wrap(
      value: software.amazon.awssdk.services.elasticache.model.SlaMet
  ): zio.aws.elasticache.model.SlaMet = value match {
    case software.amazon.awssdk.services.elasticache.model.SlaMet.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.elasticache.model.SlaMet.YES =>
      val r = yes
      r
    case software.amazon.awssdk.services.elasticache.model.SlaMet.NO =>
      val r = no
      r
    case software.amazon.awssdk.services.elasticache.model.SlaMet.N_A =>
      val r = `n/a`
      r
  }
  case object unknownToSdkVersion extends zio.aws.elasticache.model.SlaMet {
    override def unwrap
        : software.amazon.awssdk.services.elasticache.model.SlaMet =
      software.amazon.awssdk.services.elasticache.model.SlaMet.UNKNOWN_TO_SDK_VERSION
  }
  case object yes extends zio.aws.elasticache.model.SlaMet {
    override def unwrap
        : software.amazon.awssdk.services.elasticache.model.SlaMet =
      software.amazon.awssdk.services.elasticache.model.SlaMet.YES
  }
  case object no extends zio.aws.elasticache.model.SlaMet {
    override def unwrap
        : software.amazon.awssdk.services.elasticache.model.SlaMet =
      software.amazon.awssdk.services.elasticache.model.SlaMet.NO
  }
  case object `n/a` extends zio.aws.elasticache.model.SlaMet {
    override def unwrap
        : software.amazon.awssdk.services.elasticache.model.SlaMet =
      software.amazon.awssdk.services.elasticache.model.SlaMet.N_A
  }
}
