package zio.aws.elasticache.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class NodeGroupMember(
    cacheClusterId: Optional[String] = Optional.Absent,
    cacheNodeId: Optional[String] = Optional.Absent,
    readEndpoint: Optional[zio.aws.elasticache.model.Endpoint] =
      Optional.Absent,
    preferredAvailabilityZone: Optional[String] = Optional.Absent,
    preferredOutpostArn: Optional[String] = Optional.Absent,
    currentRole: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.elasticache.model.NodeGroupMember = {
    import NodeGroupMember.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.elasticache.model.NodeGroupMember
      .builder()
      .optionallyWith(cacheClusterId.map(value => value: java.lang.String))(
        _.cacheClusterId
      )
      .optionallyWith(cacheNodeId.map(value => value: java.lang.String))(
        _.cacheNodeId
      )
      .optionallyWith(readEndpoint.map(value => value.buildAwsValue()))(
        _.readEndpoint
      )
      .optionallyWith(
        preferredAvailabilityZone.map(value => value: java.lang.String)
      )(_.preferredAvailabilityZone)
      .optionallyWith(
        preferredOutpostArn.map(value => value: java.lang.String)
      )(_.preferredOutpostArn)
      .optionallyWith(currentRole.map(value => value: java.lang.String))(
        _.currentRole
      )
      .build()
  }
  def asReadOnly: zio.aws.elasticache.model.NodeGroupMember.ReadOnly =
    zio.aws.elasticache.model.NodeGroupMember.wrap(buildAwsValue())
}
object NodeGroupMember {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.elasticache.model.NodeGroupMember
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.elasticache.model.NodeGroupMember =
      zio.aws.elasticache.model.NodeGroupMember(
        cacheClusterId.map(value => value),
        cacheNodeId.map(value => value),
        readEndpoint.map(value => value.asEditable),
        preferredAvailabilityZone.map(value => value),
        preferredOutpostArn.map(value => value),
        currentRole.map(value => value)
      )
    def cacheClusterId: Optional[String]
    def cacheNodeId: Optional[String]
    def readEndpoint: Optional[zio.aws.elasticache.model.Endpoint.ReadOnly]
    def preferredAvailabilityZone: Optional[String]
    def preferredOutpostArn: Optional[String]
    def currentRole: Optional[String]
    def getCacheClusterId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("cacheClusterId", cacheClusterId)
    def getCacheNodeId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("cacheNodeId", cacheNodeId)
    def getReadEndpoint
        : ZIO[Any, AwsError, zio.aws.elasticache.model.Endpoint.ReadOnly] =
      AwsError.unwrapOptionField("readEndpoint", readEndpoint)
    def getPreferredAvailabilityZone: ZIO[Any, AwsError, String] = AwsError
      .unwrapOptionField("preferredAvailabilityZone", preferredAvailabilityZone)
    def getPreferredOutpostArn: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("preferredOutpostArn", preferredOutpostArn)
    def getCurrentRole: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("currentRole", currentRole)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.elasticache.model.NodeGroupMember
  ) extends zio.aws.elasticache.model.NodeGroupMember.ReadOnly {
    override val cacheClusterId: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.cacheClusterId())
      .map(value => value: String)
    override val cacheNodeId: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.cacheNodeId())
      .map(value => value: String)
    override val readEndpoint
        : Optional[zio.aws.elasticache.model.Endpoint.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.readEndpoint())
        .map(value => zio.aws.elasticache.model.Endpoint.wrap(value))
    override val preferredAvailabilityZone: Optional[String] =
      zio.aws.core.internal
        .optionalFromNullable(impl.preferredAvailabilityZone())
        .map(value => value: String)
    override val preferredOutpostArn: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.preferredOutpostArn())
      .map(value => value: String)
    override val currentRole: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.currentRole())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.elasticache.model.NodeGroupMember
  ): zio.aws.elasticache.model.NodeGroupMember.ReadOnly = new Wrapper(impl)
}
