package zio.aws.elasticache.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class GlobalReplicationGroupMember(
    replicationGroupId: Optional[String] = Optional.Absent,
    replicationGroupRegion: Optional[String] = Optional.Absent,
    role: Optional[String] = Optional.Absent,
    automaticFailover: Optional[
      zio.aws.elasticache.model.AutomaticFailoverStatus
    ] = Optional.Absent,
    status: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.elasticache.model.GlobalReplicationGroupMember = {
    import GlobalReplicationGroupMember.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.elasticache.model.GlobalReplicationGroupMember
      .builder()
      .optionallyWith(replicationGroupId.map(value => value: java.lang.String))(
        _.replicationGroupId
      )
      .optionallyWith(
        replicationGroupRegion.map(value => value: java.lang.String)
      )(_.replicationGroupRegion)
      .optionallyWith(role.map(value => value: java.lang.String))(_.role)
      .optionallyWith(automaticFailover.map(value => value.unwrap))(
        _.automaticFailover
      )
      .optionallyWith(status.map(value => value: java.lang.String))(_.status)
      .build()
  }
  def asReadOnly
      : zio.aws.elasticache.model.GlobalReplicationGroupMember.ReadOnly =
    zio.aws.elasticache.model.GlobalReplicationGroupMember.wrap(buildAwsValue())
}
object GlobalReplicationGroupMember {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.elasticache.model.GlobalReplicationGroupMember
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.elasticache.model.GlobalReplicationGroupMember =
      zio.aws.elasticache.model.GlobalReplicationGroupMember(
        replicationGroupId.map(value => value),
        replicationGroupRegion.map(value => value),
        role.map(value => value),
        automaticFailover.map(value => value),
        status.map(value => value)
      )
    def replicationGroupId: Optional[String]
    def replicationGroupRegion: Optional[String]
    def role: Optional[String]
    def automaticFailover
        : Optional[zio.aws.elasticache.model.AutomaticFailoverStatus]
    def status: Optional[String]
    def getReplicationGroupId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("replicationGroupId", replicationGroupId)
    def getReplicationGroupRegion: ZIO[Any, AwsError, String] = AwsError
      .unwrapOptionField("replicationGroupRegion", replicationGroupRegion)
    def getRole: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("role", role)
    def getAutomaticFailover: ZIO[
      Any,
      AwsError,
      zio.aws.elasticache.model.AutomaticFailoverStatus
    ] = AwsError.unwrapOptionField("automaticFailover", automaticFailover)
    def getStatus: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("status", status)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.elasticache.model.GlobalReplicationGroupMember
  ) extends zio.aws.elasticache.model.GlobalReplicationGroupMember.ReadOnly {
    override val replicationGroupId: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.replicationGroupId())
      .map(value => value: String)
    override val replicationGroupRegion: Optional[String] =
      zio.aws.core.internal
        .optionalFromNullable(impl.replicationGroupRegion())
        .map(value => value: String)
    override val role: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.role())
      .map(value => value: String)
    override val automaticFailover
        : Optional[zio.aws.elasticache.model.AutomaticFailoverStatus] =
      zio.aws.core.internal
        .optionalFromNullable(impl.automaticFailover())
        .map(value =>
          zio.aws.elasticache.model.AutomaticFailoverStatus.wrap(value)
        )
    override val status: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.status())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.elasticache.model.GlobalReplicationGroupMember
  ): zio.aws.elasticache.model.GlobalReplicationGroupMember.ReadOnly =
    new Wrapper(impl)
}
