package zio.aws.elasticache.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ReshardingStatus(
    slotMigration: Optional[zio.aws.elasticache.model.SlotMigration] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.elasticache.model.ReshardingStatus = {
    import ReshardingStatus.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.elasticache.model.ReshardingStatus
      .builder()
      .optionallyWith(slotMigration.map(value => value.buildAwsValue()))(
        _.slotMigration
      )
      .build()
  }
  def asReadOnly: zio.aws.elasticache.model.ReshardingStatus.ReadOnly =
    zio.aws.elasticache.model.ReshardingStatus.wrap(buildAwsValue())
}
object ReshardingStatus {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.elasticache.model.ReshardingStatus
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.elasticache.model.ReshardingStatus =
      zio.aws.elasticache.model
        .ReshardingStatus(slotMigration.map(value => value.asEditable))
    def slotMigration
        : Optional[zio.aws.elasticache.model.SlotMigration.ReadOnly]
    def getSlotMigration
        : ZIO[Any, AwsError, zio.aws.elasticache.model.SlotMigration.ReadOnly] =
      AwsError.unwrapOptionField("slotMigration", slotMigration)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.elasticache.model.ReshardingStatus
  ) extends zio.aws.elasticache.model.ReshardingStatus.ReadOnly {
    override val slotMigration
        : Optional[zio.aws.elasticache.model.SlotMigration.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.slotMigration())
        .map(value => zio.aws.elasticache.model.SlotMigration.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.elasticache.model.ReshardingStatus
  ): zio.aws.elasticache.model.ReshardingStatus.ReadOnly = new Wrapper(impl)
}
