package zio.aws.elasticache.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.elasticache.model.primitives.{BooleanOptional, IntegerOptional}
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class DescribeSnapshotsRequest(
    replicationGroupId: Optional[String] = Optional.Absent,
    cacheClusterId: Optional[String] = Optional.Absent,
    snapshotName: Optional[String] = Optional.Absent,
    snapshotSource: Optional[String] = Optional.Absent,
    marker: Optional[String] = Optional.Absent,
    maxRecords: Optional[IntegerOptional] = Optional.Absent,
    showNodeGroupConfig: Optional[BooleanOptional] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.elasticache.model.DescribeSnapshotsRequest = {
    import DescribeSnapshotsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.elasticache.model.DescribeSnapshotsRequest
      .builder()
      .optionallyWith(replicationGroupId.map(value => value: java.lang.String))(
        _.replicationGroupId
      )
      .optionallyWith(cacheClusterId.map(value => value: java.lang.String))(
        _.cacheClusterId
      )
      .optionallyWith(snapshotName.map(value => value: java.lang.String))(
        _.snapshotName
      )
      .optionallyWith(snapshotSource.map(value => value: java.lang.String))(
        _.snapshotSource
      )
      .optionallyWith(marker.map(value => value: java.lang.String))(_.marker)
      .optionallyWith(maxRecords.map(value => value: Integer))(_.maxRecords)
      .optionallyWith(
        showNodeGroupConfig.map(value => value: java.lang.Boolean)
      )(_.showNodeGroupConfig)
      .build()
  }
  def asReadOnly: zio.aws.elasticache.model.DescribeSnapshotsRequest.ReadOnly =
    zio.aws.elasticache.model.DescribeSnapshotsRequest.wrap(buildAwsValue())
}
object DescribeSnapshotsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.elasticache.model.DescribeSnapshotsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.elasticache.model.DescribeSnapshotsRequest =
      zio.aws.elasticache.model.DescribeSnapshotsRequest(
        replicationGroupId.map(value => value),
        cacheClusterId.map(value => value),
        snapshotName.map(value => value),
        snapshotSource.map(value => value),
        marker.map(value => value),
        maxRecords.map(value => value),
        showNodeGroupConfig.map(value => value)
      )
    def replicationGroupId: Optional[String]
    def cacheClusterId: Optional[String]
    def snapshotName: Optional[String]
    def snapshotSource: Optional[String]
    def marker: Optional[String]
    def maxRecords: Optional[IntegerOptional]
    def showNodeGroupConfig: Optional[BooleanOptional]
    def getReplicationGroupId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("replicationGroupId", replicationGroupId)
    def getCacheClusterId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("cacheClusterId", cacheClusterId)
    def getSnapshotName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("snapshotName", snapshotName)
    def getSnapshotSource: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("snapshotSource", snapshotSource)
    def getMarker: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("marker", marker)
    def getMaxRecords: ZIO[Any, AwsError, IntegerOptional] =
      AwsError.unwrapOptionField("maxRecords", maxRecords)
    def getShowNodeGroupConfig: ZIO[Any, AwsError, BooleanOptional] =
      AwsError.unwrapOptionField("showNodeGroupConfig", showNodeGroupConfig)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.elasticache.model.DescribeSnapshotsRequest
  ) extends zio.aws.elasticache.model.DescribeSnapshotsRequest.ReadOnly {
    override val replicationGroupId: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.replicationGroupId())
      .map(value => value: String)
    override val cacheClusterId: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.cacheClusterId())
      .map(value => value: String)
    override val snapshotName: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.snapshotName())
      .map(value => value: String)
    override val snapshotSource: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.snapshotSource())
      .map(value => value: String)
    override val marker: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.marker())
      .map(value => value: String)
    override val maxRecords: Optional[IntegerOptional] = zio.aws.core.internal
      .optionalFromNullable(impl.maxRecords())
      .map(value => value: IntegerOptional)
    override val showNodeGroupConfig: Optional[BooleanOptional] =
      zio.aws.core.internal
        .optionalFromNullable(impl.showNodeGroupConfig())
        .map(value => value: BooleanOptional)
  }
  def wrap(
      impl: software.amazon.awssdk.services.elasticache.model.DescribeSnapshotsRequest
  ): zio.aws.elasticache.model.DescribeSnapshotsRequest.ReadOnly = new Wrapper(
    impl
  )
}
