package zio.aws.elasticache.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class Subnet(
    subnetIdentifier: Optional[String] = Optional.Absent,
    subnetAvailabilityZone: Optional[
      zio.aws.elasticache.model.AvailabilityZone
    ] = Optional.Absent,
    subnetOutpost: Optional[zio.aws.elasticache.model.SubnetOutpost] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.elasticache.model.Subnet = {
    import Subnet.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.elasticache.model.Subnet
      .builder()
      .optionallyWith(subnetIdentifier.map(value => value: java.lang.String))(
        _.subnetIdentifier
      )
      .optionallyWith(
        subnetAvailabilityZone.map(value => value.buildAwsValue())
      )(_.subnetAvailabilityZone)
      .optionallyWith(subnetOutpost.map(value => value.buildAwsValue()))(
        _.subnetOutpost
      )
      .build()
  }
  def asReadOnly: zio.aws.elasticache.model.Subnet.ReadOnly =
    zio.aws.elasticache.model.Subnet.wrap(buildAwsValue())
}
object Subnet {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.elasticache.model.Subnet
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.elasticache.model.Subnet =
      zio.aws.elasticache.model.Subnet(
        subnetIdentifier.map(value => value),
        subnetAvailabilityZone.map(value => value.asEditable),
        subnetOutpost.map(value => value.asEditable)
      )
    def subnetIdentifier: Optional[String]
    def subnetAvailabilityZone
        : Optional[zio.aws.elasticache.model.AvailabilityZone.ReadOnly]
    def subnetOutpost
        : Optional[zio.aws.elasticache.model.SubnetOutpost.ReadOnly]
    def getSubnetIdentifier: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("subnetIdentifier", subnetIdentifier)
    def getSubnetAvailabilityZone: ZIO[
      Any,
      AwsError,
      zio.aws.elasticache.model.AvailabilityZone.ReadOnly
    ] = AwsError.unwrapOptionField(
      "subnetAvailabilityZone",
      subnetAvailabilityZone
    )
    def getSubnetOutpost
        : ZIO[Any, AwsError, zio.aws.elasticache.model.SubnetOutpost.ReadOnly] =
      AwsError.unwrapOptionField("subnetOutpost", subnetOutpost)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.elasticache.model.Subnet
  ) extends zio.aws.elasticache.model.Subnet.ReadOnly {
    override val subnetIdentifier: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.subnetIdentifier())
      .map(value => value: String)
    override val subnetAvailabilityZone
        : Optional[zio.aws.elasticache.model.AvailabilityZone.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.subnetAvailabilityZone())
        .map(value => zio.aws.elasticache.model.AvailabilityZone.wrap(value))
    override val subnetOutpost
        : Optional[zio.aws.elasticache.model.SubnetOutpost.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.subnetOutpost())
        .map(value => zio.aws.elasticache.model.SubnetOutpost.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.elasticache.model.Subnet
  ): zio.aws.elasticache.model.Subnet.ReadOnly = new Wrapper(impl)
}
