package zio.aws.elasticache.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class EC2SecurityGroup(
    status: Optional[String] = Optional.Absent,
    ec2SecurityGroupName: Optional[String] = Optional.Absent,
    ec2SecurityGroupOwnerId: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.elasticache.model.EC2SecurityGroup = {
    import EC2SecurityGroup.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.elasticache.model.EC2SecurityGroup
      .builder()
      .optionallyWith(status.map(value => value: java.lang.String))(_.status)
      .optionallyWith(
        ec2SecurityGroupName.map(value => value: java.lang.String)
      )(_.ec2SecurityGroupName)
      .optionallyWith(
        ec2SecurityGroupOwnerId.map(value => value: java.lang.String)
      )(_.ec2SecurityGroupOwnerId)
      .build()
  }
  def asReadOnly: zio.aws.elasticache.model.EC2SecurityGroup.ReadOnly =
    zio.aws.elasticache.model.EC2SecurityGroup.wrap(buildAwsValue())
}
object EC2SecurityGroup {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.elasticache.model.EC2SecurityGroup
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.elasticache.model.EC2SecurityGroup =
      zio.aws.elasticache.model.EC2SecurityGroup(
        status.map(value => value),
        ec2SecurityGroupName.map(value => value),
        ec2SecurityGroupOwnerId.map(value => value)
      )
    def status: Optional[String]
    def ec2SecurityGroupName: Optional[String]
    def ec2SecurityGroupOwnerId: Optional[String]
    def getStatus: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("status", status)
    def getEc2SecurityGroupName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("ec2SecurityGroupName", ec2SecurityGroupName)
    def getEc2SecurityGroupOwnerId: ZIO[Any, AwsError, String] = AwsError
      .unwrapOptionField("ec2SecurityGroupOwnerId", ec2SecurityGroupOwnerId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.elasticache.model.EC2SecurityGroup
  ) extends zio.aws.elasticache.model.EC2SecurityGroup.ReadOnly {
    override val status: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.status())
      .map(value => value: String)
    override val ec2SecurityGroupName: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.ec2SecurityGroupName())
      .map(value => value: String)
    override val ec2SecurityGroupOwnerId: Optional[String] =
      zio.aws.core.internal
        .optionalFromNullable(impl.ec2SecurityGroupOwnerId())
        .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.elasticache.model.EC2SecurityGroup
  ): zio.aws.elasticache.model.EC2SecurityGroup.ReadOnly = new Wrapper(impl)
}
