package zio.aws.elasticache.model
import zio.aws.elasticache.model.primitives.BooleanOptional
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class GlobalReplicationGroup(
    globalReplicationGroupId: Optional[String] = Optional.Absent,
    globalReplicationGroupDescription: Optional[String] = Optional.Absent,
    status: Optional[String] = Optional.Absent,
    cacheNodeType: Optional[String] = Optional.Absent,
    engine: Optional[String] = Optional.Absent,
    engineVersion: Optional[String] = Optional.Absent,
    members: Optional[
      Iterable[zio.aws.elasticache.model.GlobalReplicationGroupMember]
    ] = Optional.Absent,
    clusterEnabled: Optional[BooleanOptional] = Optional.Absent,
    globalNodeGroups: Optional[
      Iterable[zio.aws.elasticache.model.GlobalNodeGroup]
    ] = Optional.Absent,
    authTokenEnabled: Optional[BooleanOptional] = Optional.Absent,
    transitEncryptionEnabled: Optional[BooleanOptional] = Optional.Absent,
    atRestEncryptionEnabled: Optional[BooleanOptional] = Optional.Absent,
    arn: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.elasticache.model.GlobalReplicationGroup = {
    import GlobalReplicationGroup.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.elasticache.model.GlobalReplicationGroup
      .builder()
      .optionallyWith(
        globalReplicationGroupId.map(value => value: java.lang.String)
      )(_.globalReplicationGroupId)
      .optionallyWith(
        globalReplicationGroupDescription.map(value => value: java.lang.String)
      )(_.globalReplicationGroupDescription)
      .optionallyWith(status.map(value => value: java.lang.String))(_.status)
      .optionallyWith(cacheNodeType.map(value => value: java.lang.String))(
        _.cacheNodeType
      )
      .optionallyWith(engine.map(value => value: java.lang.String))(_.engine)
      .optionallyWith(engineVersion.map(value => value: java.lang.String))(
        _.engineVersion
      )
      .optionallyWith(
        members.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.members)
      .optionallyWith(clusterEnabled.map(value => value: java.lang.Boolean))(
        _.clusterEnabled
      )
      .optionallyWith(
        globalNodeGroups.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.globalNodeGroups)
      .optionallyWith(authTokenEnabled.map(value => value: java.lang.Boolean))(
        _.authTokenEnabled
      )
      .optionallyWith(
        transitEncryptionEnabled.map(value => value: java.lang.Boolean)
      )(_.transitEncryptionEnabled)
      .optionallyWith(
        atRestEncryptionEnabled.map(value => value: java.lang.Boolean)
      )(_.atRestEncryptionEnabled)
      .optionallyWith(arn.map(value => value: java.lang.String))(_.arn)
      .build()
  }
  def asReadOnly: zio.aws.elasticache.model.GlobalReplicationGroup.ReadOnly =
    zio.aws.elasticache.model.GlobalReplicationGroup.wrap(buildAwsValue())
}
object GlobalReplicationGroup {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.elasticache.model.GlobalReplicationGroup
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.elasticache.model.GlobalReplicationGroup =
      zio.aws.elasticache.model.GlobalReplicationGroup(
        globalReplicationGroupId.map(value => value),
        globalReplicationGroupDescription.map(value => value),
        status.map(value => value),
        cacheNodeType.map(value => value),
        engine.map(value => value),
        engineVersion.map(value => value),
        members.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        clusterEnabled.map(value => value),
        globalNodeGroups.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        authTokenEnabled.map(value => value),
        transitEncryptionEnabled.map(value => value),
        atRestEncryptionEnabled.map(value => value),
        arn.map(value => value)
      )
    def globalReplicationGroupId: Optional[String]
    def globalReplicationGroupDescription: Optional[String]
    def status: Optional[String]
    def cacheNodeType: Optional[String]
    def engine: Optional[String]
    def engineVersion: Optional[String]
    def members: Optional[
      List[zio.aws.elasticache.model.GlobalReplicationGroupMember.ReadOnly]
    ]
    def clusterEnabled: Optional[BooleanOptional]
    def globalNodeGroups
        : Optional[List[zio.aws.elasticache.model.GlobalNodeGroup.ReadOnly]]
    def authTokenEnabled: Optional[BooleanOptional]
    def transitEncryptionEnabled: Optional[BooleanOptional]
    def atRestEncryptionEnabled: Optional[BooleanOptional]
    def arn: Optional[String]
    def getGlobalReplicationGroupId: ZIO[Any, AwsError, String] = AwsError
      .unwrapOptionField("globalReplicationGroupId", globalReplicationGroupId)
    def getGlobalReplicationGroupDescription: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField(
        "globalReplicationGroupDescription",
        globalReplicationGroupDescription
      )
    def getStatus: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("status", status)
    def getCacheNodeType: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("cacheNodeType", cacheNodeType)
    def getEngine: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("engine", engine)
    def getEngineVersion: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("engineVersion", engineVersion)
    def getMembers: ZIO[Any, AwsError, List[
      zio.aws.elasticache.model.GlobalReplicationGroupMember.ReadOnly
    ]] = AwsError.unwrapOptionField("members", members)
    def getClusterEnabled: ZIO[Any, AwsError, BooleanOptional] =
      AwsError.unwrapOptionField("clusterEnabled", clusterEnabled)
    def getGlobalNodeGroups: ZIO[Any, AwsError, List[
      zio.aws.elasticache.model.GlobalNodeGroup.ReadOnly
    ]] = AwsError.unwrapOptionField("globalNodeGroups", globalNodeGroups)
    def getAuthTokenEnabled: ZIO[Any, AwsError, BooleanOptional] =
      AwsError.unwrapOptionField("authTokenEnabled", authTokenEnabled)
    def getTransitEncryptionEnabled: ZIO[Any, AwsError, BooleanOptional] =
      AwsError.unwrapOptionField(
        "transitEncryptionEnabled",
        transitEncryptionEnabled
      )
    def getAtRestEncryptionEnabled: ZIO[Any, AwsError, BooleanOptional] =
      AwsError.unwrapOptionField(
        "atRestEncryptionEnabled",
        atRestEncryptionEnabled
      )
    def getArn: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("arn", arn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.elasticache.model.GlobalReplicationGroup
  ) extends zio.aws.elasticache.model.GlobalReplicationGroup.ReadOnly {
    override val globalReplicationGroupId: Optional[String] =
      zio.aws.core.internal
        .optionalFromNullable(impl.globalReplicationGroupId())
        .map(value => value: String)
    override val globalReplicationGroupDescription: Optional[String] =
      zio.aws.core.internal
        .optionalFromNullable(impl.globalReplicationGroupDescription())
        .map(value => value: String)
    override val status: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.status())
      .map(value => value: String)
    override val cacheNodeType: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.cacheNodeType())
      .map(value => value: String)
    override val engine: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.engine())
      .map(value => value: String)
    override val engineVersion: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.engineVersion())
      .map(value => value: String)
    override val members: Optional[
      List[zio.aws.elasticache.model.GlobalReplicationGroupMember.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.members())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.elasticache.model.GlobalReplicationGroupMember.wrap(item)
        }.toList
      )
    override val clusterEnabled: Optional[BooleanOptional] =
      zio.aws.core.internal
        .optionalFromNullable(impl.clusterEnabled())
        .map(value => value: BooleanOptional)
    override val globalNodeGroups
        : Optional[List[zio.aws.elasticache.model.GlobalNodeGroup.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.globalNodeGroups())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.elasticache.model.GlobalNodeGroup.wrap(item)
          }.toList
        )
    override val authTokenEnabled: Optional[BooleanOptional] =
      zio.aws.core.internal
        .optionalFromNullable(impl.authTokenEnabled())
        .map(value => value: BooleanOptional)
    override val transitEncryptionEnabled: Optional[BooleanOptional] =
      zio.aws.core.internal
        .optionalFromNullable(impl.transitEncryptionEnabled())
        .map(value => value: BooleanOptional)
    override val atRestEncryptionEnabled: Optional[BooleanOptional] =
      zio.aws.core.internal
        .optionalFromNullable(impl.atRestEncryptionEnabled())
        .map(value => value: BooleanOptional)
    override val arn: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.arn())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.elasticache.model.GlobalReplicationGroup
  ): zio.aws.elasticache.model.GlobalReplicationGroup.ReadOnly = new Wrapper(
    impl
  )
}
