package zio.aws.elasticache.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class KinesisFirehoseDestinationDetails(
    deliveryStream: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.elasticache.model.KinesisFirehoseDestinationDetails = {
    import KinesisFirehoseDestinationDetails.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.elasticache.model.KinesisFirehoseDestinationDetails
      .builder()
      .optionallyWith(deliveryStream.map(value => value: java.lang.String))(
        _.deliveryStream
      )
      .build()
  }
  def asReadOnly
      : zio.aws.elasticache.model.KinesisFirehoseDestinationDetails.ReadOnly =
    zio.aws.elasticache.model.KinesisFirehoseDestinationDetails
      .wrap(buildAwsValue())
}
object KinesisFirehoseDestinationDetails {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.elasticache.model.KinesisFirehoseDestinationDetails
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.elasticache.model.KinesisFirehoseDestinationDetails =
      zio.aws.elasticache.model
        .KinesisFirehoseDestinationDetails(deliveryStream.map(value => value))
    def deliveryStream: Optional[String]
    def getDeliveryStream: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("deliveryStream", deliveryStream)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.elasticache.model.KinesisFirehoseDestinationDetails
  ) extends zio.aws.elasticache.model.KinesisFirehoseDestinationDetails.ReadOnly {
    override val deliveryStream: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.deliveryStream())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.elasticache.model.KinesisFirehoseDestinationDetails
  ): zio.aws.elasticache.model.KinesisFirehoseDestinationDetails.ReadOnly =
    new Wrapper(impl)
}
