package zio.aws.elasticache.model
import zio.aws.elasticache.model.primitives.AllowedNodeGroupId
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ReshardingConfiguration(
    nodeGroupId: Optional[AllowedNodeGroupId] = Optional.Absent,
    preferredAvailabilityZones: Optional[Iterable[String]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.elasticache.model.ReshardingConfiguration = {
    import ReshardingConfiguration.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.elasticache.model.ReshardingConfiguration
      .builder()
      .optionallyWith(
        nodeGroupId.map(value =>
          AllowedNodeGroupId.unwrap(value): java.lang.String
        )
      )(_.nodeGroupId)
      .optionallyWith(
        preferredAvailabilityZones.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.preferredAvailabilityZones)
      .build()
  }
  def asReadOnly: zio.aws.elasticache.model.ReshardingConfiguration.ReadOnly =
    zio.aws.elasticache.model.ReshardingConfiguration.wrap(buildAwsValue())
}
object ReshardingConfiguration {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.elasticache.model.ReshardingConfiguration
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.elasticache.model.ReshardingConfiguration =
      zio.aws.elasticache.model.ReshardingConfiguration(
        nodeGroupId.map(value => value),
        preferredAvailabilityZones.map(value => value)
      )
    def nodeGroupId: Optional[AllowedNodeGroupId]
    def preferredAvailabilityZones: Optional[List[String]]
    def getNodeGroupId: ZIO[Any, AwsError, AllowedNodeGroupId] =
      AwsError.unwrapOptionField("nodeGroupId", nodeGroupId)
    def getPreferredAvailabilityZones: ZIO[Any, AwsError, List[String]] =
      AwsError.unwrapOptionField(
        "preferredAvailabilityZones",
        preferredAvailabilityZones
      )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.elasticache.model.ReshardingConfiguration
  ) extends zio.aws.elasticache.model.ReshardingConfiguration.ReadOnly {
    override val nodeGroupId: Optional[AllowedNodeGroupId] =
      zio.aws.core.internal
        .optionalFromNullable(impl.nodeGroupId())
        .map(value =>
          zio.aws.elasticache.model.primitives.AllowedNodeGroupId(value)
        )
    override val preferredAvailabilityZones: Optional[List[String]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.preferredAvailabilityZones())
        .map(value =>
          value.asScala.map { item =>
            item: String
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.elasticache.model.ReshardingConfiguration
  ): zio.aws.elasticache.model.ReshardingConfiguration.ReadOnly = new Wrapper(
    impl
  )
}
