package zio.aws.elasticache.model
import zio.aws.elasticache.model.primitives.UserId
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class DeleteUserRequest(userId: UserId) {
  def buildAwsValue()
      : software.amazon.awssdk.services.elasticache.model.DeleteUserRequest = {
    import DeleteUserRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.elasticache.model.DeleteUserRequest
      .builder()
      .userId(UserId.unwrap(userId): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.elasticache.model.DeleteUserRequest.ReadOnly =
    zio.aws.elasticache.model.DeleteUserRequest.wrap(buildAwsValue())
}
object DeleteUserRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.elasticache.model.DeleteUserRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.elasticache.model.DeleteUserRequest =
      zio.aws.elasticache.model.DeleteUserRequest(userId)
    def userId: UserId
    def getUserId: ZIO[Any, Nothing, UserId] = ZIO.succeed(userId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.elasticache.model.DeleteUserRequest
  ) extends zio.aws.elasticache.model.DeleteUserRequest.ReadOnly {
    override val userId: UserId =
      zio.aws.elasticache.model.primitives.UserId(impl.userId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.elasticache.model.DeleteUserRequest
  ): zio.aws.elasticache.model.DeleteUserRequest.ReadOnly = new Wrapper(impl)
}
