package zio.aws.elasticache.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class DeleteCacheSecurityGroupRequest(
    cacheSecurityGroupName: String
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.elasticache.model.DeleteCacheSecurityGroupRequest = {
    import DeleteCacheSecurityGroupRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.elasticache.model.DeleteCacheSecurityGroupRequest
      .builder()
      .cacheSecurityGroupName(cacheSecurityGroupName: java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.elasticache.model.DeleteCacheSecurityGroupRequest.ReadOnly =
    zio.aws.elasticache.model.DeleteCacheSecurityGroupRequest
      .wrap(buildAwsValue())
}
object DeleteCacheSecurityGroupRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.elasticache.model.DeleteCacheSecurityGroupRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.elasticache.model.DeleteCacheSecurityGroupRequest =
      zio.aws.elasticache.model
        .DeleteCacheSecurityGroupRequest(cacheSecurityGroupName)
    def cacheSecurityGroupName: String
    def getCacheSecurityGroupName: ZIO[Any, Nothing, String] =
      ZIO.succeed(cacheSecurityGroupName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.elasticache.model.DeleteCacheSecurityGroupRequest
  ) extends zio.aws.elasticache.model.DeleteCacheSecurityGroupRequest.ReadOnly {
    override val cacheSecurityGroupName: String =
      impl.cacheSecurityGroupName(): String
  }
  def wrap(
      impl: software.amazon.awssdk.services.elasticache.model.DeleteCacheSecurityGroupRequest
  ): zio.aws.elasticache.model.DeleteCacheSecurityGroupRequest.ReadOnly =
    new Wrapper(impl)
}
