package zio.aws.elasticache.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.elasticache.model.primitives.IntegerOptional
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class DescribeCacheEngineVersionsRequest(
    engine: Optional[String] = Optional.Absent,
    engineVersion: Optional[String] = Optional.Absent,
    cacheParameterGroupFamily: Optional[String] = Optional.Absent,
    maxRecords: Optional[IntegerOptional] = Optional.Absent,
    marker: Optional[String] = Optional.Absent,
    defaultOnly: Optional[Boolean] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.elasticache.model.DescribeCacheEngineVersionsRequest = {
    import DescribeCacheEngineVersionsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.elasticache.model.DescribeCacheEngineVersionsRequest
      .builder()
      .optionallyWith(engine.map(value => value: java.lang.String))(_.engine)
      .optionallyWith(engineVersion.map(value => value: java.lang.String))(
        _.engineVersion
      )
      .optionallyWith(
        cacheParameterGroupFamily.map(value => value: java.lang.String)
      )(_.cacheParameterGroupFamily)
      .optionallyWith(maxRecords.map(value => value: Integer))(_.maxRecords)
      .optionallyWith(marker.map(value => value: java.lang.String))(_.marker)
      .optionallyWith(defaultOnly.map(value => value: java.lang.Boolean))(
        _.defaultOnly
      )
      .build()
  }
  def asReadOnly
      : zio.aws.elasticache.model.DescribeCacheEngineVersionsRequest.ReadOnly =
    zio.aws.elasticache.model.DescribeCacheEngineVersionsRequest
      .wrap(buildAwsValue())
}
object DescribeCacheEngineVersionsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.elasticache.model.DescribeCacheEngineVersionsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.elasticache.model.DescribeCacheEngineVersionsRequest =
      zio.aws.elasticache.model.DescribeCacheEngineVersionsRequest(
        engine.map(value => value),
        engineVersion.map(value => value),
        cacheParameterGroupFamily.map(value => value),
        maxRecords.map(value => value),
        marker.map(value => value),
        defaultOnly.map(value => value)
      )
    def engine: Optional[String]
    def engineVersion: Optional[String]
    def cacheParameterGroupFamily: Optional[String]
    def maxRecords: Optional[IntegerOptional]
    def marker: Optional[String]
    def defaultOnly: Optional[Boolean]
    def getEngine: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("engine", engine)
    def getEngineVersion: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("engineVersion", engineVersion)
    def getCacheParameterGroupFamily: ZIO[Any, AwsError, String] = AwsError
      .unwrapOptionField("cacheParameterGroupFamily", cacheParameterGroupFamily)
    def getMaxRecords: ZIO[Any, AwsError, IntegerOptional] =
      AwsError.unwrapOptionField("maxRecords", maxRecords)
    def getMarker: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("marker", marker)
    def getDefaultOnly: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("defaultOnly", defaultOnly)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.elasticache.model.DescribeCacheEngineVersionsRequest
  ) extends zio.aws.elasticache.model.DescribeCacheEngineVersionsRequest.ReadOnly {
    override val engine: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.engine())
      .map(value => value: String)
    override val engineVersion: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.engineVersion())
      .map(value => value: String)
    override val cacheParameterGroupFamily: Optional[String] =
      zio.aws.core.internal
        .optionalFromNullable(impl.cacheParameterGroupFamily())
        .map(value => value: String)
    override val maxRecords: Optional[IntegerOptional] = zio.aws.core.internal
      .optionalFromNullable(impl.maxRecords())
      .map(value => value: IntegerOptional)
    override val marker: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.marker())
      .map(value => value: String)
    override val defaultOnly: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.defaultOnly())
      .map(value => value: Boolean)
  }
  def wrap(
      impl: software.amazon.awssdk.services.elasticache.model.DescribeCacheEngineVersionsRequest
  ): zio.aws.elasticache.model.DescribeCacheEngineVersionsRequest.ReadOnly =
    new Wrapper(impl)
}
