package zio.aws.elasticache.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.elasticache.model.primitives.TStamp
import scala.jdk.CollectionConverters._
final case class TimeRangeFilter(
    startTime: Optional[TStamp] = Optional.Absent,
    endTime: Optional[TStamp] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.elasticache.model.TimeRangeFilter = {
    import TimeRangeFilter.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.elasticache.model.TimeRangeFilter
      .builder()
      .optionallyWith(startTime.map(value => TStamp.unwrap(value): Instant))(
        _.startTime
      )
      .optionallyWith(endTime.map(value => TStamp.unwrap(value): Instant))(
        _.endTime
      )
      .build()
  }
  def asReadOnly: zio.aws.elasticache.model.TimeRangeFilter.ReadOnly =
    zio.aws.elasticache.model.TimeRangeFilter.wrap(buildAwsValue())
}
object TimeRangeFilter {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.elasticache.model.TimeRangeFilter
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.elasticache.model.TimeRangeFilter =
      zio.aws.elasticache.model.TimeRangeFilter(
        startTime.map(value => value),
        endTime.map(value => value)
      )
    def startTime: Optional[TStamp]
    def endTime: Optional[TStamp]
    def getStartTime: ZIO[Any, AwsError, TStamp] =
      AwsError.unwrapOptionField("startTime", startTime)
    def getEndTime: ZIO[Any, AwsError, TStamp] =
      AwsError.unwrapOptionField("endTime", endTime)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.elasticache.model.TimeRangeFilter
  ) extends zio.aws.elasticache.model.TimeRangeFilter.ReadOnly {
    override val startTime: Optional[TStamp] = zio.aws.core.internal
      .optionalFromNullable(impl.startTime())
      .map(value => zio.aws.elasticache.model.primitives.TStamp(value))
    override val endTime: Optional[TStamp] = zio.aws.core.internal
      .optionalFromNullable(impl.endTime())
      .map(value => zio.aws.elasticache.model.primitives.TStamp(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.elasticache.model.TimeRangeFilter
  ): zio.aws.elasticache.model.TimeRangeFilter.ReadOnly = new Wrapper(impl)
}
