package zio.aws.elasticache.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class CreateCacheParameterGroupRequest(
    cacheParameterGroupName: String,
    cacheParameterGroupFamily: String,
    description: String,
    tags: Optional[Iterable[zio.aws.elasticache.model.Tag]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.elasticache.model.CreateCacheParameterGroupRequest = {
    import CreateCacheParameterGroupRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.elasticache.model.CreateCacheParameterGroupRequest
      .builder()
      .cacheParameterGroupName(cacheParameterGroupName: java.lang.String)
      .cacheParameterGroupFamily(cacheParameterGroupFamily: java.lang.String)
      .description(description: java.lang.String)
      .optionallyWith(
        tags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tags)
      .build()
  }
  def asReadOnly
      : zio.aws.elasticache.model.CreateCacheParameterGroupRequest.ReadOnly =
    zio.aws.elasticache.model.CreateCacheParameterGroupRequest
      .wrap(buildAwsValue())
}
object CreateCacheParameterGroupRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.elasticache.model.CreateCacheParameterGroupRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.elasticache.model.CreateCacheParameterGroupRequest =
      zio.aws.elasticache.model.CreateCacheParameterGroupRequest(
        cacheParameterGroupName,
        cacheParameterGroupFamily,
        description,
        tags.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def cacheParameterGroupName: String
    def cacheParameterGroupFamily: String
    def description: String
    def tags: Optional[List[zio.aws.elasticache.model.Tag.ReadOnly]]
    def getCacheParameterGroupName: ZIO[Any, Nothing, String] =
      ZIO.succeed(cacheParameterGroupName)
    def getCacheParameterGroupFamily: ZIO[Any, Nothing, String] =
      ZIO.succeed(cacheParameterGroupFamily)
    def getDescription: ZIO[Any, Nothing, String] = ZIO.succeed(description)
    def getTags
        : ZIO[Any, AwsError, List[zio.aws.elasticache.model.Tag.ReadOnly]] =
      AwsError.unwrapOptionField("tags", tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.elasticache.model.CreateCacheParameterGroupRequest
  ) extends zio.aws.elasticache.model.CreateCacheParameterGroupRequest.ReadOnly {
    override val cacheParameterGroupName: String =
      impl.cacheParameterGroupName(): String
    override val cacheParameterGroupFamily: String =
      impl.cacheParameterGroupFamily(): String
    override val description: String = impl.description(): String
    override val tags: Optional[List[zio.aws.elasticache.model.Tag.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.tags())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.elasticache.model.Tag.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.elasticache.model.CreateCacheParameterGroupRequest
  ): zio.aws.elasticache.model.CreateCacheParameterGroupRequest.ReadOnly =
    new Wrapper(impl)
}
