package zio.aws.elasticache.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ModifyCacheSubnetGroupRequest(
    cacheSubnetGroupName: String,
    cacheSubnetGroupDescription: Optional[String] = Optional.Absent,
    subnetIds: Optional[Iterable[String]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.elasticache.model.ModifyCacheSubnetGroupRequest = {
    import ModifyCacheSubnetGroupRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.elasticache.model.ModifyCacheSubnetGroupRequest
      .builder()
      .cacheSubnetGroupName(cacheSubnetGroupName: java.lang.String)
      .optionallyWith(
        cacheSubnetGroupDescription.map(value => value: java.lang.String)
      )(_.cacheSubnetGroupDescription)
      .optionallyWith(
        subnetIds.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.subnetIds)
      .build()
  }
  def asReadOnly
      : zio.aws.elasticache.model.ModifyCacheSubnetGroupRequest.ReadOnly =
    zio.aws.elasticache.model.ModifyCacheSubnetGroupRequest
      .wrap(buildAwsValue())
}
object ModifyCacheSubnetGroupRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.elasticache.model.ModifyCacheSubnetGroupRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.elasticache.model.ModifyCacheSubnetGroupRequest =
      zio.aws.elasticache.model.ModifyCacheSubnetGroupRequest(
        cacheSubnetGroupName,
        cacheSubnetGroupDescription.map(value => value),
        subnetIds.map(value => value)
      )
    def cacheSubnetGroupName: String
    def cacheSubnetGroupDescription: Optional[String]
    def subnetIds: Optional[List[String]]
    def getCacheSubnetGroupName: ZIO[Any, Nothing, String] =
      ZIO.succeed(cacheSubnetGroupName)
    def getCacheSubnetGroupDescription: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField(
        "cacheSubnetGroupDescription",
        cacheSubnetGroupDescription
      )
    def getSubnetIds: ZIO[Any, AwsError, List[String]] =
      AwsError.unwrapOptionField("subnetIds", subnetIds)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.elasticache.model.ModifyCacheSubnetGroupRequest
  ) extends zio.aws.elasticache.model.ModifyCacheSubnetGroupRequest.ReadOnly {
    override val cacheSubnetGroupName: String =
      impl.cacheSubnetGroupName(): String
    override val cacheSubnetGroupDescription: Optional[String] =
      zio.aws.core.internal
        .optionalFromNullable(impl.cacheSubnetGroupDescription())
        .map(value => value: String)
    override val subnetIds: Optional[List[String]] = zio.aws.core.internal
      .optionalFromNullable(impl.subnetIds())
      .map(value =>
        value.asScala.map { item =>
          item: String
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.elasticache.model.ModifyCacheSubnetGroupRequest
  ): zio.aws.elasticache.model.ModifyCacheSubnetGroupRequest.ReadOnly =
    new Wrapper(impl)
}
