package zio.aws.elasticache.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class CacheSubnetGroup(
    cacheSubnetGroupName: Optional[String] = Optional.Absent,
    cacheSubnetGroupDescription: Optional[String] = Optional.Absent,
    vpcId: Optional[String] = Optional.Absent,
    subnets: Optional[Iterable[zio.aws.elasticache.model.Subnet]] =
      Optional.Absent,
    arn: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.elasticache.model.CacheSubnetGroup = {
    import CacheSubnetGroup.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.elasticache.model.CacheSubnetGroup
      .builder()
      .optionallyWith(
        cacheSubnetGroupName.map(value => value: java.lang.String)
      )(_.cacheSubnetGroupName)
      .optionallyWith(
        cacheSubnetGroupDescription.map(value => value: java.lang.String)
      )(_.cacheSubnetGroupDescription)
      .optionallyWith(vpcId.map(value => value: java.lang.String))(_.vpcId)
      .optionallyWith(
        subnets.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.subnets)
      .optionallyWith(arn.map(value => value: java.lang.String))(_.arn)
      .build()
  }
  def asReadOnly: zio.aws.elasticache.model.CacheSubnetGroup.ReadOnly =
    zio.aws.elasticache.model.CacheSubnetGroup.wrap(buildAwsValue())
}
object CacheSubnetGroup {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.elasticache.model.CacheSubnetGroup
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.elasticache.model.CacheSubnetGroup =
      zio.aws.elasticache.model.CacheSubnetGroup(
        cacheSubnetGroupName.map(value => value),
        cacheSubnetGroupDescription.map(value => value),
        vpcId.map(value => value),
        subnets.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        arn.map(value => value)
      )
    def cacheSubnetGroupName: Optional[String]
    def cacheSubnetGroupDescription: Optional[String]
    def vpcId: Optional[String]
    def subnets: Optional[List[zio.aws.elasticache.model.Subnet.ReadOnly]]
    def arn: Optional[String]
    def getCacheSubnetGroupName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("cacheSubnetGroupName", cacheSubnetGroupName)
    def getCacheSubnetGroupDescription: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField(
        "cacheSubnetGroupDescription",
        cacheSubnetGroupDescription
      )
    def getVpcId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("vpcId", vpcId)
    def getSubnets
        : ZIO[Any, AwsError, List[zio.aws.elasticache.model.Subnet.ReadOnly]] =
      AwsError.unwrapOptionField("subnets", subnets)
    def getArn: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("arn", arn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.elasticache.model.CacheSubnetGroup
  ) extends zio.aws.elasticache.model.CacheSubnetGroup.ReadOnly {
    override val cacheSubnetGroupName: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.cacheSubnetGroupName())
      .map(value => value: String)
    override val cacheSubnetGroupDescription: Optional[String] =
      zio.aws.core.internal
        .optionalFromNullable(impl.cacheSubnetGroupDescription())
        .map(value => value: String)
    override val vpcId: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.vpcId())
      .map(value => value: String)
    override val subnets
        : Optional[List[zio.aws.elasticache.model.Subnet.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.subnets())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.elasticache.model.Subnet.wrap(item)
          }.toList
        )
    override val arn: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.arn())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.elasticache.model.CacheSubnetGroup
  ): zio.aws.elasticache.model.CacheSubnetGroup.ReadOnly = new Wrapper(impl)
}
