package zio.aws.elasticache.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.elasticache.model.primitives.{
  UserGroupId,
  TStamp,
  BooleanOptional,
  IntegerOptional
}
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class ReplicationGroup(
    replicationGroupId: Optional[String] = Optional.Absent,
    description: Optional[String] = Optional.Absent,
    globalReplicationGroupInfo: Optional[
      zio.aws.elasticache.model.GlobalReplicationGroupInfo
    ] = Optional.Absent,
    status: Optional[String] = Optional.Absent,
    pendingModifiedValues: Optional[
      zio.aws.elasticache.model.ReplicationGroupPendingModifiedValues
    ] = Optional.Absent,
    memberClusters: Optional[Iterable[String]] = Optional.Absent,
    nodeGroups: Optional[Iterable[zio.aws.elasticache.model.NodeGroup]] =
      Optional.Absent,
    snapshottingClusterId: Optional[String] = Optional.Absent,
    automaticFailover: Optional[
      zio.aws.elasticache.model.AutomaticFailoverStatus
    ] = Optional.Absent,
    multiAZ: Optional[zio.aws.elasticache.model.MultiAZStatus] =
      Optional.Absent,
    configurationEndpoint: Optional[zio.aws.elasticache.model.Endpoint] =
      Optional.Absent,
    snapshotRetentionLimit: Optional[IntegerOptional] = Optional.Absent,
    snapshotWindow: Optional[String] = Optional.Absent,
    clusterEnabled: Optional[BooleanOptional] = Optional.Absent,
    cacheNodeType: Optional[String] = Optional.Absent,
    authTokenEnabled: Optional[BooleanOptional] = Optional.Absent,
    authTokenLastModifiedDate: Optional[TStamp] = Optional.Absent,
    transitEncryptionEnabled: Optional[BooleanOptional] = Optional.Absent,
    atRestEncryptionEnabled: Optional[BooleanOptional] = Optional.Absent,
    memberClustersOutpostArns: Optional[Iterable[String]] = Optional.Absent,
    kmsKeyId: Optional[String] = Optional.Absent,
    arn: Optional[String] = Optional.Absent,
    userGroupIds: Optional[Iterable[UserGroupId]] = Optional.Absent,
    logDeliveryConfigurations: Optional[
      Iterable[zio.aws.elasticache.model.LogDeliveryConfiguration]
    ] = Optional.Absent,
    replicationGroupCreateTime: Optional[TStamp] = Optional.Absent,
    dataTiering: Optional[zio.aws.elasticache.model.DataTieringStatus] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.elasticache.model.ReplicationGroup = {
    import ReplicationGroup.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.elasticache.model.ReplicationGroup
      .builder()
      .optionallyWith(replicationGroupId.map(value => value: java.lang.String))(
        _.replicationGroupId
      )
      .optionallyWith(description.map(value => value: java.lang.String))(
        _.description
      )
      .optionallyWith(
        globalReplicationGroupInfo.map(value => value.buildAwsValue())
      )(_.globalReplicationGroupInfo)
      .optionallyWith(status.map(value => value: java.lang.String))(_.status)
      .optionallyWith(
        pendingModifiedValues.map(value => value.buildAwsValue())
      )(_.pendingModifiedValues)
      .optionallyWith(
        memberClusters.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.memberClusters)
      .optionallyWith(
        nodeGroups.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.nodeGroups)
      .optionallyWith(
        snapshottingClusterId.map(value => value: java.lang.String)
      )(_.snapshottingClusterId)
      .optionallyWith(automaticFailover.map(value => value.unwrap))(
        _.automaticFailover
      )
      .optionallyWith(multiAZ.map(value => value.unwrap))(_.multiAZ)
      .optionallyWith(
        configurationEndpoint.map(value => value.buildAwsValue())
      )(_.configurationEndpoint)
      .optionallyWith(snapshotRetentionLimit.map(value => value: Integer))(
        _.snapshotRetentionLimit
      )
      .optionallyWith(snapshotWindow.map(value => value: java.lang.String))(
        _.snapshotWindow
      )
      .optionallyWith(clusterEnabled.map(value => value: java.lang.Boolean))(
        _.clusterEnabled
      )
      .optionallyWith(cacheNodeType.map(value => value: java.lang.String))(
        _.cacheNodeType
      )
      .optionallyWith(authTokenEnabled.map(value => value: java.lang.Boolean))(
        _.authTokenEnabled
      )
      .optionallyWith(
        authTokenLastModifiedDate.map(value => TStamp.unwrap(value): Instant)
      )(_.authTokenLastModifiedDate)
      .optionallyWith(
        transitEncryptionEnabled.map(value => value: java.lang.Boolean)
      )(_.transitEncryptionEnabled)
      .optionallyWith(
        atRestEncryptionEnabled.map(value => value: java.lang.Boolean)
      )(_.atRestEncryptionEnabled)
      .optionallyWith(
        memberClustersOutpostArns.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.memberClustersOutpostArns)
      .optionallyWith(kmsKeyId.map(value => value: java.lang.String))(
        _.kmsKeyId
      )
      .optionallyWith(arn.map(value => value: java.lang.String))(_.arn)
      .optionallyWith(
        userGroupIds.map(value =>
          value.map { item =>
            UserGroupId.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.userGroupIds)
      .optionallyWith(
        logDeliveryConfigurations.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.logDeliveryConfigurations)
      .optionallyWith(
        replicationGroupCreateTime.map(value => TStamp.unwrap(value): Instant)
      )(_.replicationGroupCreateTime)
      .optionallyWith(dataTiering.map(value => value.unwrap))(_.dataTiering)
      .build()
  }
  def asReadOnly: zio.aws.elasticache.model.ReplicationGroup.ReadOnly =
    zio.aws.elasticache.model.ReplicationGroup.wrap(buildAwsValue())
}
object ReplicationGroup {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.elasticache.model.ReplicationGroup
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.elasticache.model.ReplicationGroup =
      zio.aws.elasticache.model.ReplicationGroup(
        replicationGroupId.map(value => value),
        description.map(value => value),
        globalReplicationGroupInfo.map(value => value.asEditable),
        status.map(value => value),
        pendingModifiedValues.map(value => value.asEditable),
        memberClusters.map(value => value),
        nodeGroups.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        snapshottingClusterId.map(value => value),
        automaticFailover.map(value => value),
        multiAZ.map(value => value),
        configurationEndpoint.map(value => value.asEditable),
        snapshotRetentionLimit.map(value => value),
        snapshotWindow.map(value => value),
        clusterEnabled.map(value => value),
        cacheNodeType.map(value => value),
        authTokenEnabled.map(value => value),
        authTokenLastModifiedDate.map(value => value),
        transitEncryptionEnabled.map(value => value),
        atRestEncryptionEnabled.map(value => value),
        memberClustersOutpostArns.map(value => value),
        kmsKeyId.map(value => value),
        arn.map(value => value),
        userGroupIds.map(value => value),
        logDeliveryConfigurations.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        replicationGroupCreateTime.map(value => value),
        dataTiering.map(value => value)
      )
    def replicationGroupId: Optional[String]
    def description: Optional[String]
    def globalReplicationGroupInfo: Optional[
      zio.aws.elasticache.model.GlobalReplicationGroupInfo.ReadOnly
    ]
    def status: Optional[String]
    def pendingModifiedValues: Optional[
      zio.aws.elasticache.model.ReplicationGroupPendingModifiedValues.ReadOnly
    ]
    def memberClusters: Optional[List[String]]
    def nodeGroups: Optional[List[zio.aws.elasticache.model.NodeGroup.ReadOnly]]
    def snapshottingClusterId: Optional[String]
    def automaticFailover
        : Optional[zio.aws.elasticache.model.AutomaticFailoverStatus]
    def multiAZ: Optional[zio.aws.elasticache.model.MultiAZStatus]
    def configurationEndpoint
        : Optional[zio.aws.elasticache.model.Endpoint.ReadOnly]
    def snapshotRetentionLimit: Optional[IntegerOptional]
    def snapshotWindow: Optional[String]
    def clusterEnabled: Optional[BooleanOptional]
    def cacheNodeType: Optional[String]
    def authTokenEnabled: Optional[BooleanOptional]
    def authTokenLastModifiedDate: Optional[TStamp]
    def transitEncryptionEnabled: Optional[BooleanOptional]
    def atRestEncryptionEnabled: Optional[BooleanOptional]
    def memberClustersOutpostArns: Optional[List[String]]
    def kmsKeyId: Optional[String]
    def arn: Optional[String]
    def userGroupIds: Optional[List[UserGroupId]]
    def logDeliveryConfigurations: Optional[
      List[zio.aws.elasticache.model.LogDeliveryConfiguration.ReadOnly]
    ]
    def replicationGroupCreateTime: Optional[TStamp]
    def dataTiering: Optional[zio.aws.elasticache.model.DataTieringStatus]
    def getReplicationGroupId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("replicationGroupId", replicationGroupId)
    def getDescription: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("description", description)
    def getGlobalReplicationGroupInfo: ZIO[
      Any,
      AwsError,
      zio.aws.elasticache.model.GlobalReplicationGroupInfo.ReadOnly
    ] = AwsError.unwrapOptionField(
      "globalReplicationGroupInfo",
      globalReplicationGroupInfo
    )
    def getStatus: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("status", status)
    def getPendingModifiedValues: ZIO[
      Any,
      AwsError,
      zio.aws.elasticache.model.ReplicationGroupPendingModifiedValues.ReadOnly
    ] =
      AwsError.unwrapOptionField("pendingModifiedValues", pendingModifiedValues)
    def getMemberClusters: ZIO[Any, AwsError, List[String]] =
      AwsError.unwrapOptionField("memberClusters", memberClusters)
    def getNodeGroups: ZIO[Any, AwsError, List[
      zio.aws.elasticache.model.NodeGroup.ReadOnly
    ]] = AwsError.unwrapOptionField("nodeGroups", nodeGroups)
    def getSnapshottingClusterId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("snapshottingClusterId", snapshottingClusterId)
    def getAutomaticFailover: ZIO[
      Any,
      AwsError,
      zio.aws.elasticache.model.AutomaticFailoverStatus
    ] = AwsError.unwrapOptionField("automaticFailover", automaticFailover)
    def getMultiAZ
        : ZIO[Any, AwsError, zio.aws.elasticache.model.MultiAZStatus] =
      AwsError.unwrapOptionField("multiAZ", multiAZ)
    def getConfigurationEndpoint
        : ZIO[Any, AwsError, zio.aws.elasticache.model.Endpoint.ReadOnly] =
      AwsError.unwrapOptionField("configurationEndpoint", configurationEndpoint)
    def getSnapshotRetentionLimit: ZIO[Any, AwsError, IntegerOptional] =
      AwsError.unwrapOptionField(
        "snapshotRetentionLimit",
        snapshotRetentionLimit
      )
    def getSnapshotWindow: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("snapshotWindow", snapshotWindow)
    def getClusterEnabled: ZIO[Any, AwsError, BooleanOptional] =
      AwsError.unwrapOptionField("clusterEnabled", clusterEnabled)
    def getCacheNodeType: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("cacheNodeType", cacheNodeType)
    def getAuthTokenEnabled: ZIO[Any, AwsError, BooleanOptional] =
      AwsError.unwrapOptionField("authTokenEnabled", authTokenEnabled)
    def getAuthTokenLastModifiedDate: ZIO[Any, AwsError, TStamp] = AwsError
      .unwrapOptionField("authTokenLastModifiedDate", authTokenLastModifiedDate)
    def getTransitEncryptionEnabled: ZIO[Any, AwsError, BooleanOptional] =
      AwsError.unwrapOptionField(
        "transitEncryptionEnabled",
        transitEncryptionEnabled
      )
    def getAtRestEncryptionEnabled: ZIO[Any, AwsError, BooleanOptional] =
      AwsError.unwrapOptionField(
        "atRestEncryptionEnabled",
        atRestEncryptionEnabled
      )
    def getMemberClustersOutpostArns: ZIO[Any, AwsError, List[String]] =
      AwsError.unwrapOptionField(
        "memberClustersOutpostArns",
        memberClustersOutpostArns
      )
    def getKmsKeyId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("kmsKeyId", kmsKeyId)
    def getArn: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("arn", arn)
    def getUserGroupIds: ZIO[Any, AwsError, List[UserGroupId]] =
      AwsError.unwrapOptionField("userGroupIds", userGroupIds)
    def getLogDeliveryConfigurations: ZIO[Any, AwsError, List[
      zio.aws.elasticache.model.LogDeliveryConfiguration.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "logDeliveryConfigurations",
      logDeliveryConfigurations
    )
    def getReplicationGroupCreateTime: ZIO[Any, AwsError, TStamp] =
      AwsError.unwrapOptionField(
        "replicationGroupCreateTime",
        replicationGroupCreateTime
      )
    def getDataTiering
        : ZIO[Any, AwsError, zio.aws.elasticache.model.DataTieringStatus] =
      AwsError.unwrapOptionField("dataTiering", dataTiering)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.elasticache.model.ReplicationGroup
  ) extends zio.aws.elasticache.model.ReplicationGroup.ReadOnly {
    override val replicationGroupId: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.replicationGroupId())
      .map(value => value: String)
    override val description: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.description())
      .map(value => value: String)
    override val globalReplicationGroupInfo: Optional[
      zio.aws.elasticache.model.GlobalReplicationGroupInfo.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.globalReplicationGroupInfo())
      .map(value =>
        zio.aws.elasticache.model.GlobalReplicationGroupInfo.wrap(value)
      )
    override val status: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.status())
      .map(value => value: String)
    override val pendingModifiedValues: Optional[
      zio.aws.elasticache.model.ReplicationGroupPendingModifiedValues.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.pendingModifiedValues())
      .map(value =>
        zio.aws.elasticache.model.ReplicationGroupPendingModifiedValues
          .wrap(value)
      )
    override val memberClusters: Optional[List[String]] = zio.aws.core.internal
      .optionalFromNullable(impl.memberClusters())
      .map(value =>
        value.asScala.map { item =>
          item: String
        }.toList
      )
    override val nodeGroups
        : Optional[List[zio.aws.elasticache.model.NodeGroup.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.nodeGroups())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.elasticache.model.NodeGroup.wrap(item)
          }.toList
        )
    override val snapshottingClusterId: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.snapshottingClusterId())
      .map(value => value: String)
    override val automaticFailover
        : Optional[zio.aws.elasticache.model.AutomaticFailoverStatus] =
      zio.aws.core.internal
        .optionalFromNullable(impl.automaticFailover())
        .map(value =>
          zio.aws.elasticache.model.AutomaticFailoverStatus.wrap(value)
        )
    override val multiAZ: Optional[zio.aws.elasticache.model.MultiAZStatus] =
      zio.aws.core.internal
        .optionalFromNullable(impl.multiAZ())
        .map(value => zio.aws.elasticache.model.MultiAZStatus.wrap(value))
    override val configurationEndpoint
        : Optional[zio.aws.elasticache.model.Endpoint.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.configurationEndpoint())
        .map(value => zio.aws.elasticache.model.Endpoint.wrap(value))
    override val snapshotRetentionLimit: Optional[IntegerOptional] =
      zio.aws.core.internal
        .optionalFromNullable(impl.snapshotRetentionLimit())
        .map(value => value: IntegerOptional)
    override val snapshotWindow: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.snapshotWindow())
      .map(value => value: String)
    override val clusterEnabled: Optional[BooleanOptional] =
      zio.aws.core.internal
        .optionalFromNullable(impl.clusterEnabled())
        .map(value => value: BooleanOptional)
    override val cacheNodeType: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.cacheNodeType())
      .map(value => value: String)
    override val authTokenEnabled: Optional[BooleanOptional] =
      zio.aws.core.internal
        .optionalFromNullable(impl.authTokenEnabled())
        .map(value => value: BooleanOptional)
    override val authTokenLastModifiedDate: Optional[TStamp] =
      zio.aws.core.internal
        .optionalFromNullable(impl.authTokenLastModifiedDate())
        .map(value => zio.aws.elasticache.model.primitives.TStamp(value))
    override val transitEncryptionEnabled: Optional[BooleanOptional] =
      zio.aws.core.internal
        .optionalFromNullable(impl.transitEncryptionEnabled())
        .map(value => value: BooleanOptional)
    override val atRestEncryptionEnabled: Optional[BooleanOptional] =
      zio.aws.core.internal
        .optionalFromNullable(impl.atRestEncryptionEnabled())
        .map(value => value: BooleanOptional)
    override val memberClustersOutpostArns: Optional[List[String]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.memberClustersOutpostArns())
        .map(value =>
          value.asScala.map { item =>
            item: String
          }.toList
        )
    override val kmsKeyId: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.kmsKeyId())
      .map(value => value: String)
    override val arn: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.arn())
      .map(value => value: String)
    override val userGroupIds: Optional[List[UserGroupId]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.userGroupIds())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.elasticache.model.primitives.UserGroupId(item)
          }.toList
        )
    override val logDeliveryConfigurations: Optional[
      List[zio.aws.elasticache.model.LogDeliveryConfiguration.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.logDeliveryConfigurations())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.elasticache.model.LogDeliveryConfiguration.wrap(item)
        }.toList
      )
    override val replicationGroupCreateTime: Optional[TStamp] =
      zio.aws.core.internal
        .optionalFromNullable(impl.replicationGroupCreateTime())
        .map(value => zio.aws.elasticache.model.primitives.TStamp(value))
    override val dataTiering
        : Optional[zio.aws.elasticache.model.DataTieringStatus] =
      zio.aws.core.internal
        .optionalFromNullable(impl.dataTiering())
        .map(value => zio.aws.elasticache.model.DataTieringStatus.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.elasticache.model.ReplicationGroup
  ): zio.aws.elasticache.model.ReplicationGroup.ReadOnly = new Wrapper(impl)
}
