package zio.aws.elasticache.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class FailoverGlobalReplicationGroupRequest(
    globalReplicationGroupId: String,
    primaryRegion: String,
    primaryReplicationGroupId: String
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.elasticache.model.FailoverGlobalReplicationGroupRequest = {
    import FailoverGlobalReplicationGroupRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.elasticache.model.FailoverGlobalReplicationGroupRequest
      .builder()
      .globalReplicationGroupId(globalReplicationGroupId: java.lang.String)
      .primaryRegion(primaryRegion: java.lang.String)
      .primaryReplicationGroupId(primaryReplicationGroupId: java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.elasticache.model.FailoverGlobalReplicationGroupRequest.ReadOnly =
    zio.aws.elasticache.model.FailoverGlobalReplicationGroupRequest
      .wrap(buildAwsValue())
}
object FailoverGlobalReplicationGroupRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.elasticache.model.FailoverGlobalReplicationGroupRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.elasticache.model.FailoverGlobalReplicationGroupRequest =
      zio.aws.elasticache.model.FailoverGlobalReplicationGroupRequest(
        globalReplicationGroupId,
        primaryRegion,
        primaryReplicationGroupId
      )
    def globalReplicationGroupId: String
    def primaryRegion: String
    def primaryReplicationGroupId: String
    def getGlobalReplicationGroupId: ZIO[Any, Nothing, String] =
      ZIO.succeed(globalReplicationGroupId)
    def getPrimaryRegion: ZIO[Any, Nothing, String] = ZIO.succeed(primaryRegion)
    def getPrimaryReplicationGroupId: ZIO[Any, Nothing, String] =
      ZIO.succeed(primaryReplicationGroupId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.elasticache.model.FailoverGlobalReplicationGroupRequest
  ) extends zio.aws.elasticache.model.FailoverGlobalReplicationGroupRequest.ReadOnly {
    override val globalReplicationGroupId: String =
      impl.globalReplicationGroupId(): String
    override val primaryRegion: String = impl.primaryRegion(): String
    override val primaryReplicationGroupId: String =
      impl.primaryReplicationGroupId(): String
  }
  def wrap(
      impl: software.amazon.awssdk.services.elasticache.model.FailoverGlobalReplicationGroupRequest
  ): zio.aws.elasticache.model.FailoverGlobalReplicationGroupRequest.ReadOnly =
    new Wrapper(impl)
}
