package zio.aws.elasticache.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class DeleteCacheClusterRequest(
    cacheClusterId: String,
    finalSnapshotIdentifier: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.elasticache.model.DeleteCacheClusterRequest = {
    import DeleteCacheClusterRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.elasticache.model.DeleteCacheClusterRequest
      .builder()
      .cacheClusterId(cacheClusterId: java.lang.String)
      .optionallyWith(
        finalSnapshotIdentifier.map(value => value: java.lang.String)
      )(_.finalSnapshotIdentifier)
      .build()
  }
  def asReadOnly: zio.aws.elasticache.model.DeleteCacheClusterRequest.ReadOnly =
    zio.aws.elasticache.model.DeleteCacheClusterRequest.wrap(buildAwsValue())
}
object DeleteCacheClusterRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.elasticache.model.DeleteCacheClusterRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.elasticache.model.DeleteCacheClusterRequest =
      zio.aws.elasticache.model.DeleteCacheClusterRequest(
        cacheClusterId,
        finalSnapshotIdentifier.map(value => value)
      )
    def cacheClusterId: String
    def finalSnapshotIdentifier: Optional[String]
    def getCacheClusterId: ZIO[Any, Nothing, String] =
      ZIO.succeed(cacheClusterId)
    def getFinalSnapshotIdentifier: ZIO[Any, AwsError, String] = AwsError
      .unwrapOptionField("finalSnapshotIdentifier", finalSnapshotIdentifier)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.elasticache.model.DeleteCacheClusterRequest
  ) extends zio.aws.elasticache.model.DeleteCacheClusterRequest.ReadOnly {
    override val cacheClusterId: String = impl.cacheClusterId(): String
    override val finalSnapshotIdentifier: Optional[String] =
      zio.aws.core.internal
        .optionalFromNullable(impl.finalSnapshotIdentifier())
        .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.elasticache.model.DeleteCacheClusterRequest
  ): zio.aws.elasticache.model.DeleteCacheClusterRequest.ReadOnly = new Wrapper(
    impl
  )
}
